/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class ConsumerCreateRequest
implements JsonSerializable {
    private final String streamName;
    private final ConsumerConfiguration config;
    private final Action action;

    public ConsumerCreateRequest(String streamName, ConsumerConfiguration config) {
        this.streamName = streamName;
        this.config = config;
        this.action = Action.CreateOrUpdate;
    }

    public ConsumerCreateRequest(String streamName, ConsumerConfiguration config, Action action) {
        this.streamName = streamName;
        this.config = config;
        this.action = action;
    }

    @NotNull
    public String getStreamName() {
        return this.streamName;
    }

    @NotNull
    public ConsumerConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    @Override
    @NotNull
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "stream_name", this.streamName);
        JsonUtils.addField(sb, "action", this.action.actionText);
        JsonUtils.addField(sb, "config", this.config);
        return JsonUtils.endJson(sb).toString();
    }

    public String toString() {
        return "ConsumerCreateRequest{streamName='" + this.streamName + '\'' + ", " + this.config + '}';
    }

    public static enum Action {
        Create("create"),
        Update("update"),
        CreateOrUpdate(null);

        public final String actionText;

        private Action(String actionText) {
            this.actionText = actionText;
        }
    }
}

