/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import org.jetbrains.annotations.Nullable;

public enum KeyValueOperation {
    PUT("PUT"),
    DELETE("DEL"),
    PURGE("PURGE");

    private final String headerValue;

    private KeyValueOperation(String headerValue) {
        this.headerValue = headerValue;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    @Nullable
    public static KeyValueOperation instance(String s) {
        if (KeyValueOperation.PUT.headerValue.equals(s)) {
            return PUT;
        }
        if (KeyValueOperation.DELETE.headerValue.equals(s)) {
            return DELETE;
        }
        if (KeyValueOperation.PURGE.headerValue.equals(s)) {
            return PURGE;
        }
        return null;
    }

    @Nullable
    public static KeyValueOperation getOrDefault(String s, KeyValueOperation dflt) {
        KeyValueOperation kvo = KeyValueOperation.instance(s);
        return kvo == null ? dflt : kvo;
    }

    @Nullable
    public static KeyValueOperation instanceByMarkerReason(String markerReason) {
        if ("Remove".equals(markerReason)) {
            return DELETE;
        }
        if ("MaxAge".equals(markerReason) || "Purge".equals(markerReason)) {
            return PURGE;
        }
        return null;
    }
}

