/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class MessageDeleteRequest
implements JsonSerializable {
    private final long sequence;
    private final boolean erase;

    public MessageDeleteRequest(long sequence, boolean erase) {
        this.sequence = sequence;
        this.erase = erase;
    }

    public long getSequence() {
        return this.sequence;
    }

    public boolean isErase() {
        return this.erase;
    }

    public boolean isNoErase() {
        return !this.erase;
    }

    @Override
    @NotNull
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "seq", this.sequence);
        JsonUtils.addFldWhenTrue(sb, "no_erase", this.isNoErase());
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long seq = -1L;
        private boolean erase = true;

        public Builder sequence(long seq) {
            this.seq = seq;
            return this;
        }

        public Builder erase() {
            this.erase = true;
            return this;
        }

        public Builder noErase() {
            this.erase = false;
            return this;
        }

        public MessageDeleteRequest build() {
            return new MessageDeleteRequest(this.seq, this.erase);
        }
    }
}

