/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrderedConsumerConfiguration
implements JsonSerializable {
    private final List<String> filterSubjects = new ArrayList<String>();
    private DeliverPolicy deliverPolicy;
    private Long startSequence = -1L;
    private ZonedDateTime startTime;
    private ReplayPolicy replayPolicy;
    private Boolean headersOnly;
    private String consumerNamePrefix;

    public OrderedConsumerConfiguration() {
        this.filterSubjects.add(">");
    }

    public OrderedConsumerConfiguration(@NotNull String json) throws JsonParseException {
        this(JsonParser.parse(json));
    }

    public OrderedConsumerConfiguration(@NotNull JsonValue v) throws JsonParseException {
        this();
        this.filterSubjects(JsonValueUtils.readStringList(v, "filter_subjects"));
        this.deliverPolicy(DeliverPolicy.get(JsonValueUtils.readString(v, "deliver_policy")));
        this.startSequence(JsonValueUtils.readLong(v, "opt_start_seq", -1L));
        this.startTime(JsonValueUtils.readDate(v, "opt_start_time"));
        this.replayPolicy(ReplayPolicy.get(JsonValueUtils.readString(v, "replay_policy")));
        this.headersOnly(JsonValueUtils.readBoolean(v, "headers_only", null));
    }

    @Override
    @NotNull
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addStrings(sb, "filter_subjects", this.filterSubjects);
        if (this.deliverPolicy != null) {
            JsonUtils.addField(sb, "deliver_policy", this.deliverPolicy.toString());
        }
        JsonUtils.addFieldWhenGtZero(sb, "opt_start_seq", this.startSequence);
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        if (this.replayPolicy != null) {
            JsonUtils.addField(sb, "replay_policy", this.replayPolicy.toString());
        }
        JsonUtils.addFldWhenTrue(sb, "headers_only", this.headersOnly);
        return JsonUtils.endJson(sb).toString();
    }

    public OrderedConsumerConfiguration filterSubject(String filterSubject) {
        return this.filterSubjects(Collections.singletonList(filterSubject));
    }

    public OrderedConsumerConfiguration filterSubjects(String ... filterSubjects) {
        return filterSubjects == null ? this.filterSubjects((List<String>)null) : this.filterSubjects(Arrays.asList(filterSubjects));
    }

    public OrderedConsumerConfiguration filterSubjects(List<String> filterSubjects) {
        this.filterSubjects.clear();
        if (filterSubjects != null) {
            for (String fs : filterSubjects) {
                String fsEan = Validator.emptyAsNull(fs);
                if (fsEan == null) continue;
                this.filterSubjects.add(fsEan);
            }
        }
        if (this.filterSubjects.isEmpty()) {
            this.filterSubjects.add(">");
        }
        return this;
    }

    public OrderedConsumerConfiguration deliverPolicy(DeliverPolicy deliverPolicy) {
        this.deliverPolicy = deliverPolicy;
        return this;
    }

    public OrderedConsumerConfiguration startSequence(long startSequence) {
        this.startSequence = startSequence < 1L ? -1L : startSequence;
        return this;
    }

    public OrderedConsumerConfiguration startTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OrderedConsumerConfiguration replayPolicy(ReplayPolicy replayPolicy) {
        this.replayPolicy = replayPolicy;
        return this;
    }

    public OrderedConsumerConfiguration headersOnly(Boolean headersOnly) {
        this.headersOnly = headersOnly != null && headersOnly != false ? Boolean.valueOf(true) : null;
        return this;
    }

    public OrderedConsumerConfiguration consumerNamePrefix(String consumerNamePrefix) {
        this.consumerNamePrefix = Validator.emptyAsNull(consumerNamePrefix);
        return this;
    }

    public String getFilterSubject() {
        return this.filterSubjects == null || this.filterSubjects.size() != 1 ? null : this.filterSubjects.get(0);
    }

    public List<String> getFilterSubjects() {
        return this.filterSubjects;
    }

    public boolean hasMultipleFilterSubjects() {
        return this.filterSubjects != null && this.filterSubjects.size() > 1;
    }

    public DeliverPolicy getDeliverPolicy() {
        return this.deliverPolicy;
    }

    public Long getStartSequence() {
        return this.startSequence;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ReplayPolicy getReplayPolicy() {
        return this.replayPolicy;
    }

    public Boolean getHeadersOnly() {
        return this.headersOnly;
    }

    public String getConsumerNamePrefix() {
        return this.consumerNamePrefix;
    }
}

