/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ObjectInfo;
import io.nats.client.api.ObjectStoreWatchOption;
import io.nats.client.api.ObjectStoreWatcher;
import io.nats.client.api.Watcher;
import io.nats.client.impl.NatsObjectStore;
import io.nats.client.impl.NatsWatchSubscription;
import java.io.IOException;
import java.util.Collections;

public class NatsObjectStoreWatchSubscription
extends NatsWatchSubscription<ObjectInfo> {
    public NatsObjectStoreWatchSubscription(NatsObjectStore os, final ObjectStoreWatcher watcher, ObjectStoreWatchOption ... watchOptions) throws IOException, JetStreamApiException {
        super(os.js);
        boolean headersOnly = false;
        boolean ignoreDeletes = false;
        DeliverPolicy deliverPolicy = DeliverPolicy.LastPerSubject;
        block5: for (ObjectStoreWatchOption wo : watchOptions) {
            if (wo == null) continue;
            switch (wo) {
                case IGNORE_DELETE: {
                    ignoreDeletes = true;
                    continue block5;
                }
                case UPDATES_ONLY: {
                    deliverPolicy = DeliverPolicy.New;
                    continue block5;
                }
                case INCLUDE_HISTORY: {
                    deliverPolicy = DeliverPolicy.All;
                }
            }
        }
        final boolean includeDeletes = !ignoreDeletes;
        NatsWatchSubscription.WatchMessageHandler<ObjectInfo> handler = new NatsWatchSubscription.WatchMessageHandler<ObjectInfo>((Watcher)watcher){

            @Override
            public void onMessage(Message m) throws InterruptedException {
                ObjectInfo os = new ObjectInfo(m);
                if (includeDeletes || !os.isDeleted()) {
                    watcher.watch(os);
                }
                if (!this.endOfDataSent && m.metaData().pendingCount() == 0L) {
                    this.sendEndOfData();
                }
            }
        };
        this.finishInit(os, Collections.singletonList(os.rawAllMetaSubject()), deliverPolicy, headersOnly, 0L, handler, watcher.getConsumerNamePrefix());
    }
}

