/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ConnectionListener;
import io.nats.client.ConsumerContext;
import io.nats.client.Dispatcher;
import io.nats.client.ForceReconnectOptions;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamOptions;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueManagement;
import io.nats.client.KeyValueOptions;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.ObjectStore;
import io.nats.client.ObjectStoreManagement;
import io.nats.client.ObjectStoreOptions;
import io.nats.client.Options;
import io.nats.client.Statistics;
import io.nats.client.StreamContext;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import io.nats.client.impl.Headers;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface Connection
extends AutoCloseable {
    public void publish(@NonNull String var1, byte @Nullable [] var2);

    public void publish(@NonNull String var1, @Nullable Headers var2, byte @Nullable [] var3);

    public void publish(@NonNull String var1, @Nullable String var2, byte @Nullable [] var3);

    public void publish(@NonNull String var1, @Nullable String var2, @Nullable Headers var3, byte @Nullable [] var4);

    public void publish(@NonNull Message var1);

    public @NonNull CompletableFuture<Message> request(@NonNull String var1, byte @Nullable [] var2);

    public @NonNull CompletableFuture<Message> request(@NonNull String var1, @Nullable Headers var2, byte @Nullable [] var3);

    public @NonNull CompletableFuture<Message> requestWithTimeout(@NonNull String var1, byte @Nullable [] var2, @Nullable Duration var3);

    public @NonNull CompletableFuture<Message> requestWithTimeout(@NonNull String var1, @Nullable Headers var2, byte @Nullable [] var3, Duration var4);

    public @NonNull CompletableFuture<Message> request(@NonNull Message var1);

    public @NonNull CompletableFuture<Message> requestWithTimeout(@NonNull Message var1, @Nullable Duration var2);

    public @Nullable Message request(@NonNull String var1, byte @Nullable [] var2, @Nullable Duration var3) throws InterruptedException;

    public @Nullable Message request(@NonNull String var1, @Nullable Headers var2, byte @Nullable [] var3, @Nullable Duration var4) throws InterruptedException;

    public @Nullable Message request(@NonNull Message var1, @Nullable Duration var2) throws InterruptedException;

    public @NonNull Subscription subscribe(@NonNull String var1);

    public @NonNull Subscription subscribe(@NonNull String var1, @NonNull String var2);

    public @NonNull Dispatcher createDispatcher(@Nullable MessageHandler var1);

    public @NonNull Dispatcher createDispatcher();

    public void closeDispatcher(@NonNull Dispatcher var1);

    public void addConnectionListener(@NonNull ConnectionListener var1);

    public void removeConnectionListener(@NonNull ConnectionListener var1);

    public void flush(@Nullable Duration var1) throws TimeoutException, InterruptedException;

    public @NonNull CompletableFuture<Boolean> drain(@Nullable Duration var1) throws TimeoutException, InterruptedException;

    @Override
    public void close() throws InterruptedException;

    public @NonNull Status getStatus();

    public long getMaxPayload();

    public @NonNull Collection<String> getServers();

    public @NonNull Statistics getStatistics();

    public @NonNull Options getOptions();

    public @NonNull ServerInfo getServerInfo();

    public @Nullable String getConnectedUrl();

    public @Nullable InetAddress getClientInetAddress();

    public @Nullable String getLastError();

    public void clearLastError();

    public @NonNull String createInbox();

    public void flushBuffer() throws IOException;

    public void forceReconnect() throws IOException, InterruptedException;

    public void forceReconnect(@Nullable ForceReconnectOptions var1) throws IOException, InterruptedException;

    public @NonNull Duration RTT() throws IOException;

    public @NonNull StreamContext getStreamContext(@NonNull String var1) throws IOException, JetStreamApiException;

    public @NonNull StreamContext getStreamContext(@NonNull String var1, @Nullable JetStreamOptions var2) throws IOException, JetStreamApiException;

    public @NonNull ConsumerContext getConsumerContext(@NonNull String var1, @NonNull String var2) throws IOException, JetStreamApiException;

    public @NonNull ConsumerContext getConsumerContext(@NonNull String var1, @NonNull String var2, @Nullable JetStreamOptions var3) throws IOException, JetStreamApiException;

    public @NonNull JetStream jetStream() throws IOException;

    public @NonNull JetStream jetStream(@Nullable JetStreamOptions var1) throws IOException;

    public @NonNull JetStreamManagement jetStreamManagement() throws IOException;

    public @NonNull JetStreamManagement jetStreamManagement(@Nullable JetStreamOptions var1) throws IOException;

    public @NonNull KeyValue keyValue(@NonNull String var1) throws IOException;

    public @NonNull KeyValue keyValue(@NonNull String var1, @Nullable KeyValueOptions var2) throws IOException;

    public @NonNull KeyValueManagement keyValueManagement() throws IOException;

    public @NonNull KeyValueManagement keyValueManagement(@Nullable KeyValueOptions var1) throws IOException;

    public @NonNull ObjectStore objectStore(@NonNull String var1) throws IOException;

    public @NonNull ObjectStore objectStore(@NonNull String var1, @Nullable ObjectStoreOptions var2) throws IOException;

    public @NonNull ObjectStoreManagement objectStoreManagement() throws IOException;

    public @NonNull ObjectStoreManagement objectStoreManagement(ObjectStoreOptions var1) throws IOException;

    public static enum Status {
        DISCONNECTED,
        CONNECTED,
        CLOSED,
        RECONNECTING,
        CONNECTING;

    }
}

