/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.BaseConsumeOptions;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;

public class FetchConsumeOptions
extends BaseConsumeOptions {
    public static final FetchConsumeOptions DEFAULT_FETCH_OPTIONS = FetchConsumeOptions.builder().build();
    private final boolean noWait;

    private FetchConsumeOptions(Builder b) {
        super(b);
        this.noWait = b.noWait;
    }

    @Override
    protected void subclassSpecificToJson(StringBuilder sb) {
        JsonUtils.addFldWhenTrue(sb, "no_wait", this.noWait);
    }

    public int getMaxMessages() {
        return this.messages;
    }

    public long getMaxBytes() {
        return this.bytes;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseConsumeOptions.Builder<Builder, FetchConsumeOptions> {
        protected boolean noWait = false;

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder jsonValue(JsonValue jsonValue) {
            super.jsonValue(jsonValue);
            if (JsonValueUtils.readBoolean(jsonValue, "no_wait", false).booleanValue()) {
                this.noWaitExpiresIn(JsonValueUtils.readLong(jsonValue, "expires_in", -1L));
            }
            return this;
        }

        public Builder maxMessages(int maxMessages) {
            this.messages(maxMessages);
            return (Builder)this.bytes(-1L);
        }

        public Builder maxBytes(long maxBytes) {
            return (Builder)super.bytes(maxBytes);
        }

        public Builder max(int maxBytes, int maxMessages) {
            this.messages(maxMessages);
            return (Builder)this.bytes(maxBytes);
        }

        @Override
        public Builder expiresIn(long expiresInMillis) {
            if (this.noWait && expiresInMillis < 1L) {
                this.expiresIn = -1L;
                return this;
            }
            return (Builder)super.expiresIn(expiresInMillis);
        }

        public Builder noWait() {
            this.noWait = true;
            this.expiresIn = -1L;
            return this;
        }

        public Builder noWaitExpiresIn(long expiresInMillis) {
            this.noWait = true;
            return this.expiresIn(expiresInMillis);
        }

        @Override
        public FetchConsumeOptions build() {
            return new FetchConsumeOptions(this);
        }
    }
}

