/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.impl.Headers;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.IncomingHeadersProcessor;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.NatsJetStreamConstants;
import io.nats.client.support.Status;
import java.time.ZonedDateTime;
import org.jspecify.annotations.Nullable;

public class MessageInfo
extends ApiResponse<MessageInfo> {
    private final String subject;
    private final long seq;
    private final byte[] data;
    private final ZonedDateTime time;
    private final Headers headers;
    private final String stream;
    private final long lastSeq;
    private final long numPending;
    private final Status status;

    @Deprecated
    public MessageInfo(Message msg) {
        this(msg, null, null, false);
    }

    public MessageInfo(Message msg, String streamName, boolean parseDirect) {
        this(msg, null, streamName, parseDirect);
    }

    public MessageInfo(Status status, String streamName) {
        this(null, status, streamName, false);
    }

    private MessageInfo(Message msg, Status status, String streamName, boolean parseDirect) {
        super(parseDirect ? null : msg);
        String _subject = null;
        long _seq = -1L;
        byte[] _data = null;
        ZonedDateTime _time = null;
        Headers _headers = null;
        String _stream = null;
        long _lastSeq = -1L;
        long _numPending = -1L;
        Status _status = null;
        if (status != null) {
            _status = status;
            _stream = streamName;
        } else if (parseDirect) {
            String tempNumPending;
            Headers msgHeaders = msg.getHeaders();
            _subject = msgHeaders.getLast("Nats-Subject");
            _data = msg.getData();
            _seq = Long.parseLong(msgHeaders.getLast("Nats-Sequence"));
            _time = DateTimeUtils.parseDateTime(msgHeaders.getLast("Nats-Time-Stamp"));
            _stream = msgHeaders.getLast("Nats-Stream");
            String tempLastSeq = msgHeaders.getLast("Nats-Last-Sequence");
            if (tempLastSeq != null) {
                _lastSeq = JsonUtils.safeParseLong(tempLastSeq, -1L);
            }
            if ((tempNumPending = msgHeaders.getLast("Nats-Num-Pending")) != null) {
                _numPending = Long.parseLong(tempNumPending) - 1L;
            }
            _headers = new Headers(msgHeaders, true, NatsJetStreamConstants.MESSAGE_INFO_HEADERS);
        } else if (!this.hasError()) {
            JsonValue mjv = JsonValueUtils.readValue(this.jv, "message");
            _subject = JsonValueUtils.readString(mjv, "subject");
            _data = JsonValueUtils.readBase64(mjv, "data");
            _seq = JsonValueUtils.readLong(mjv, "seq", 0L);
            _time = JsonValueUtils.readDate(mjv, "time");
            byte[] hdrBytes = JsonValueUtils.readBase64(mjv, "hdrs");
            _headers = hdrBytes == null ? null : new IncomingHeadersProcessor(hdrBytes).getHeaders();
            _stream = streamName;
        }
        this.subject = _subject;
        this.data = _data;
        this.seq = _seq;
        this.time = _time;
        this.headers = _headers;
        this.stream = _stream;
        this.lastSeq = _lastSeq;
        this.numPending = _numPending;
        this.status = _status;
    }

    public @Nullable String getSubject() {
        return this.subject;
    }

    public long getSeq() {
        return this.seq;
    }

    public byte @Nullable [] getData() {
        return this.data;
    }

    public @Nullable ZonedDateTime getTime() {
        return this.time;
    }

    public @Nullable Headers getHeaders() {
        return this.headers;
    }

    public @Nullable String getStream() {
        return this.stream;
    }

    public long getLastSeq() {
        return this.lastSeq;
    }

    public long getNumPending() {
        return this.numPending;
    }

    public @Nullable Status getStatus() {
        return this.status;
    }

    public boolean isMessage() {
        return this.status == null && !this.hasError();
    }

    public boolean isStatus() {
        return this.status != null;
    }

    public boolean isEobStatus() {
        return this.status != null && this.status.isEob();
    }

    public boolean isErrorStatus() {
        return this.status != null && !this.status.isEob();
    }

    @Override
    public String toString() {
        StringBuilder sb = JsonUtils.beginJsonPrefixed("\"MessageInfo\":");
        if (this.status != null) {
            JsonUtils.addField(sb, "status_code", this.status.getCode());
            JsonUtils.addField(sb, "status_message", this.status.getMessage());
        } else if (this.hasError()) {
            JsonUtils.addField(sb, "error", this.getError());
        } else {
            JsonUtils.addField(sb, "seq", this.seq);
            JsonUtils.addField(sb, "last_seq", this.lastSeq);
            JsonUtils.addFieldWhenGteMinusOne(sb, "num_pending", this.numPending);
            JsonUtils.addField(sb, "stream", this.stream);
            JsonUtils.addField(sb, "subject", this.subject);
            JsonUtils.addField(sb, "time", this.time);
            if (this.data == null) {
                JsonUtils.addRawJson(sb, "data", "null");
            } else {
                JsonUtils.addField(sb, "data_length", this.data.length);
            }
            JsonUtils.addField(sb, "hdrs", this.headers);
        }
        return JsonUtils.endJson(sb).toString();
    }
}

