/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.support.JsonValueUtils;
import java.io.IOException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class PublishAck
extends ApiResponse<PublishAck> {
    private final String stream;
    private final long seq;
    private final String domain;
    private final boolean duplicate;

    public PublishAck(Message msg) throws IOException, JetStreamApiException {
        super(msg);
        this.throwOnHasError();
        this.stream = JsonValueUtils.readString(this.jv, "stream");
        if (this.stream == null) {
            throw new IOException("Invalid JetStream ack.");
        }
        this.seq = JsonValueUtils.readLong(this.jv, "seq", -1L);
        if (this.seq < 0L) {
            throw new IOException("Invalid JetStream ack.");
        }
        this.domain = JsonValueUtils.readString(this.jv, "domain");
        this.duplicate = JsonValueUtils.readBoolean(this.jv, "duplicate");
    }

    public long getSeqno() {
        return this.seq;
    }

    public @NonNull String getStream() {
        return this.stream;
    }

    public @Nullable String getDomain() {
        return this.domain;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }
}

