/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ForceReconnectOptions;
import io.nats.client.NatsSystemClock;
import io.nats.client.Options;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.SocketDataPort;
import io.nats.client.support.NatsUri;
import io.nats.client.support.ScheduledTask;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.NonNull;

public class SocketDataPortWithWriteTimeout
extends SocketDataPort {
    private long writeTimeoutNanos;
    private long delayPeriodMillis;
    private ScheduledTask writeWatchTask;
    private final AtomicLong writeMustBeDoneBy = new AtomicLong(Long.MAX_VALUE);

    @Override
    public void afterConstruct(Options options) {
        super.afterConstruct(options);
        long writeTimeoutMillis = options.getSocketWriteTimeout() == null ? Options.DEFAULT_SOCKET_WRITE_TIMEOUT.toMillis() : options.getSocketWriteTimeout().toMillis();
        this.delayPeriodMillis = writeTimeoutMillis * 51L / 100L;
        this.writeTimeoutNanos = writeTimeoutMillis * 1000000L;
    }

    @Override
    public void connect(@NonNull NatsConnection conn, @NonNull NatsUri nuri, long timeoutNanos) throws IOException {
        super.connect(conn, nuri, timeoutNanos);
        this.writeWatchTask = new ScheduledTask(conn.getScheduledExecutor(), this.delayPeriodMillis, () -> {
            if (NatsSystemClock.nanoTime() > this.writeMustBeDoneBy.get()) {
                this.writeWatchTask.shutdown();
                this.connection.executeCallback((c, el) -> el.socketWriteTimeout(c));
                try {
                    this.connection.forceReconnect(ForceReconnectOptions.FORCE_CLOSE_INSTANCE);
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    @Override
    public void write(byte[] src, int toWrite) throws IOException {
        this.writeMustBeDoneBy.set(NatsSystemClock.nanoTime() + this.writeTimeoutNanos);
        this.out.write(src, 0, toWrite);
        this.writeMustBeDoneBy.set(Long.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.writeWatchTask.shutdown();
        super.close();
    }
}

