/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ScheduledTask
implements Runnable {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final String id;
    private final Runnable runnable;
    protected final AtomicReference<ScheduledFuture<?>> scheduledFutureRef;
    protected final AtomicBoolean notShutdown;
    protected final AtomicBoolean executing;
    protected final long initialDelayNanos;
    protected final long periodNanos;

    public ScheduledTask(ScheduledExecutorService ses, long initialAndPeriodMillis, Runnable runnable) {
        this(null, ses, initialAndPeriodMillis, initialAndPeriodMillis, TimeUnit.MILLISECONDS, runnable);
    }

    public ScheduledTask(String id, ScheduledExecutorService ses, long initialAndPeriodMillis, Runnable runnable) {
        this(id, ses, initialAndPeriodMillis, initialAndPeriodMillis, TimeUnit.MILLISECONDS, runnable);
    }

    public ScheduledTask(ScheduledExecutorService ses, long initialAndPeriod, TimeUnit unit, Runnable runnable) {
        this(null, ses, initialAndPeriod, initialAndPeriod, unit, runnable);
    }

    public ScheduledTask(String id, ScheduledExecutorService ses, long initialAndPeriod, TimeUnit unit, Runnable runnable) {
        this(id, ses, initialAndPeriod, initialAndPeriod, unit, runnable);
    }

    public ScheduledTask(ScheduledExecutorService ses, long initialDelay, long period, TimeUnit unit, Runnable runnable) {
        this(null, ses, initialDelay, period, unit, runnable);
    }

    public ScheduledTask(String id, ScheduledExecutorService ses, long initialDelay, long period, TimeUnit unit, Runnable runnable) {
        this.id = id == null || id.isEmpty() ? "st-" + ID_GENERATOR.getAndIncrement() : id;
        this.runnable = runnable;
        this.notShutdown = new AtomicBoolean(true);
        this.executing = new AtomicBoolean(false);
        this.initialDelayNanos = unit.toNanos(initialDelay);
        this.periodNanos = unit.toNanos(period);
        this.scheduledFutureRef = new AtomicReference(ses.scheduleAtFixedRate(this, initialDelay, period, unit));
    }

    public long getInitialDelayNanos() {
        return this.initialDelayNanos;
    }

    public long getPeriodNanos() {
        return this.periodNanos;
    }

    @Override
    public void run() {
        try {
            if (this.notShutdown.get()) {
                this.executing.set(true);
                this.runnable.run();
            }
        }
        finally {
            this.executing.set(false);
        }
    }

    public boolean isShutdown() {
        return !this.notShutdown.get();
    }

    public boolean isExecuting() {
        return this.executing.get();
    }

    public boolean isDone() {
        ScheduledFuture<?> f = this.scheduledFutureRef.get();
        return f == null || f.isDone();
    }

    public String getId() {
        return this.id;
    }

    public void shutdown() {
        try {
            this.notShutdown.set(false);
            ScheduledFuture<?> f = this.scheduledFutureRef.get();
            if (f != null) {
                this.scheduledFutureRef.set(null);
                if (!f.isDone()) {
                    f.cancel(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.id);
        if (this.notShutdown.get()) {
            sb.append(" [live");
        } else {
            sb.append(" [shutdown");
        }
        sb.append(this.isDone() ? "/done" : "/!done");
        sb.append(this.executing.get() ? "/executing" : "/!executing");
        sb.append("]");
        return sb.toString();
    }
}

