/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.PriorityPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ConsumerConfiguration
implements JsonSerializable {
    @Deprecated
    public static final Duration DURATION_MIN = Duration.ofNanos(1L);
    public static final DeliverPolicy DEFAULT_DELIVER_POLICY = DeliverPolicy.All;
    public static final AckPolicy DEFAULT_ACK_POLICY = AckPolicy.Explicit;
    public static final ReplayPolicy DEFAULT_REPLAY_POLICY = ReplayPolicy.Instant;
    public static final PriorityPolicy DEFAULT_PRIORITY_POLICY = PriorityPolicy.None;
    public static final Duration DURATION_UNSET = Duration.ZERO;
    public static final Duration MIN_IDLE_HEARTBEAT = Duration.ofMillis(100L);
    public static final int INTEGER_UNSET = -1;
    public static final long LONG_UNSET = -1L;
    public static final long ULONG_UNSET = 0L;
    public static final long DURATION_UNSET_LONG = 0L;
    public static final long DURATION_MIN_LONG = 1L;
    public static final int STANDARD_MIN = 0;
    public static final int MAX_DELIVER_MIN = 1;
    public static final long MIN_IDLE_HEARTBEAT_NANOS = MIN_IDLE_HEARTBEAT.toNanos();
    public static final long MIN_IDLE_HEARTBEAT_MILLIS = MIN_IDLE_HEARTBEAT.toMillis();
    protected final DeliverPolicy deliverPolicy;
    protected final AckPolicy ackPolicy;
    protected final ReplayPolicy replayPolicy;
    protected final String description;
    protected final String durable;
    protected final String name;
    protected final String deliverSubject;
    protected final String deliverGroup;
    protected final String sampleFrequency;
    protected final ZonedDateTime startTime;
    protected final Duration ackWait;
    protected final Duration idleHeartbeat;
    protected final Duration maxExpires;
    protected final Duration inactiveThreshold;
    protected final Long startSeq;
    protected final Integer maxDeliver;
    protected final Long rateLimit;
    protected final Integer maxAckPending;
    protected final Integer maxPullWaiting;
    protected final Integer maxBatch;
    protected final Integer maxBytes;
    protected final Integer numReplicas;
    protected final ZonedDateTime pauseUntil;
    protected final Boolean flowControl;
    protected final Boolean headersOnly;
    protected final Boolean memStorage;
    protected final List<Duration> backoff;
    protected final Map<String, String> metadata;
    protected final List<String> filterSubjects;
    protected final List<String> priorityGroups;
    protected final PriorityPolicy priorityPolicy;

    protected ConsumerConfiguration(ConsumerConfiguration cc) {
        this.deliverPolicy = cc.deliverPolicy;
        this.ackPolicy = cc.ackPolicy;
        this.replayPolicy = cc.replayPolicy;
        this.description = cc.description;
        this.durable = cc.durable;
        this.name = cc.name;
        this.deliverSubject = cc.deliverSubject;
        this.deliverGroup = cc.deliverGroup;
        this.sampleFrequency = cc.sampleFrequency;
        this.startTime = cc.startTime;
        this.ackWait = cc.ackWait;
        this.idleHeartbeat = cc.idleHeartbeat;
        this.maxExpires = cc.maxExpires;
        this.inactiveThreshold = cc.inactiveThreshold;
        this.startSeq = cc.startSeq;
        this.maxDeliver = cc.maxDeliver;
        this.rateLimit = cc.rateLimit;
        this.maxAckPending = cc.maxAckPending;
        this.maxPullWaiting = cc.maxPullWaiting;
        this.maxBatch = cc.maxBatch;
        this.maxBytes = cc.maxBytes;
        this.numReplicas = cc.numReplicas;
        this.pauseUntil = cc.pauseUntil;
        this.flowControl = cc.flowControl;
        this.headersOnly = cc.headersOnly;
        this.memStorage = cc.memStorage;
        this.backoff = cc.backoff == null ? null : new ArrayList<Duration>(cc.backoff);
        this.metadata = cc.metadata == null ? null : new HashMap<String, String>(cc.metadata);
        this.filterSubjects = cc.filterSubjects == null ? null : new ArrayList<String>(cc.filterSubjects);
        this.priorityGroups = cc.priorityGroups == null ? null : new ArrayList<String>(cc.priorityGroups);
        this.priorityPolicy = cc.priorityPolicy;
    }

    protected ConsumerConfiguration(Builder b) {
        this.deliverPolicy = b.deliverPolicy;
        this.ackPolicy = b.ackPolicy;
        this.replayPolicy = b.replayPolicy;
        this.description = b.description;
        this.durable = b.durable;
        this.name = b.name;
        this.startTime = b.startTime;
        this.ackWait = b.ackWait;
        this.sampleFrequency = b.sampleFrequency;
        this.deliverSubject = b.deliverSubject;
        this.deliverGroup = b.deliverGroup;
        this.idleHeartbeat = b.idleHeartbeat;
        this.maxExpires = b.maxExpires;
        this.inactiveThreshold = b.inactiveThreshold;
        this.startSeq = b.startSeq;
        this.maxDeliver = b.maxDeliver;
        this.rateLimit = b.rateLimit;
        this.maxAckPending = b.maxAckPending;
        this.maxPullWaiting = b.maxPullWaiting;
        this.maxBatch = b.maxBatch;
        this.maxBytes = b.maxBytes;
        this.numReplicas = b.numReplicas;
        this.pauseUntil = b.pauseUntil;
        this.flowControl = b.flowControl;
        this.headersOnly = b.headersOnly;
        this.memStorage = b.memStorage;
        this.backoff = b.backoff;
        this.metadata = b.metadata;
        this.filterSubjects = b.filterSubjects;
        this.priorityGroups = b.priorityGroups;
        this.priorityPolicy = b.priorityPolicy;
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addField(sb, "durable_name", this.durable);
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "deliver_subject", this.deliverSubject);
        JsonUtils.addField(sb, "deliver_group", this.deliverGroup);
        JsonUtils.addField(sb, "deliver_policy", ConsumerConfiguration.GetOrDefault(this.deliverPolicy).toString());
        JsonUtils.addFieldWhenGtZero(sb, "opt_start_seq", this.startSeq);
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        JsonUtils.addField(sb, "ack_policy", ConsumerConfiguration.GetOrDefault(this.ackPolicy).toString());
        JsonUtils.addFieldAsNanos(sb, "ack_wait", this.ackWait);
        JsonUtils.addFieldWhenGtZero(sb, "max_deliver", this.maxDeliver);
        JsonUtils.addField(sb, "max_ack_pending", this.maxAckPending);
        JsonUtils.addField(sb, "replay_policy", ConsumerConfiguration.GetOrDefault(this.replayPolicy).toString());
        JsonUtils.addField(sb, "sample_freq", this.sampleFrequency);
        JsonUtils.addFieldWhenGtZero(sb, "rate_limit_bps", this.rateLimit);
        JsonUtils.addFieldAsNanos(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addFldWhenTrue(sb, "flow_control", this.flowControl);
        JsonUtils.addField(sb, "max_waiting", this.maxPullWaiting);
        JsonUtils.addFldWhenTrue(sb, "headers_only", this.headersOnly);
        JsonUtils.addField(sb, "max_batch", this.maxBatch);
        JsonUtils.addField(sb, "max_bytes", this.maxBytes);
        JsonUtils.addFieldAsNanos(sb, "max_expires", this.maxExpires);
        JsonUtils.addFieldAsNanos(sb, "inactive_threshold", this.inactiveThreshold);
        JsonUtils.addDurations(sb, "backoff", this.backoff);
        JsonUtils.addField(sb, "num_replicas", this.numReplicas);
        JsonUtils.addField(sb, "pause_until", this.pauseUntil);
        JsonUtils.addField(sb, "mem_storage", this.memStorage);
        JsonUtils.addField(sb, "metadata", this.metadata);
        if (this.filterSubjects != null) {
            if (this.filterSubjects.size() > 1) {
                JsonUtils.addStrings(sb, "filter_subjects", this.filterSubjects);
            } else if (this.filterSubjects.size() == 1) {
                JsonUtils.addField(sb, "filter_subject", this.filterSubjects.get(0));
            }
        }
        JsonUtils.addStrings(sb, "priority_groups", this.priorityGroups);
        if (this.priorityPolicy != null && this.priorityPolicy != DEFAULT_PRIORITY_POLICY) {
            JsonUtils.addField(sb, "priority_policy", this.priorityPolicy.toString());
        }
        return JsonUtils.endJson(sb).toString();
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @Nullable String getDurable() {
        return this.durable;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getDeliverSubject() {
        return this.deliverSubject;
    }

    public @Nullable String getDeliverGroup() {
        return this.deliverGroup;
    }

    public @NonNull DeliverPolicy getDeliverPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.deliverPolicy);
    }

    public long getStartSequence() {
        return ConsumerConfiguration.getOrUnsetUlong(this.startSeq);
    }

    public @Nullable ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public @NonNull AckPolicy getAckPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.ackPolicy);
    }

    public @Nullable Duration getAckWait() {
        return this.ackWait;
    }

    public long getMaxDeliver() {
        return ConsumerConfiguration.getOrUnset(this.maxDeliver);
    }

    public @Nullable String getFilterSubject() {
        return this.filterSubjects == null || this.filterSubjects.size() != 1 ? null : this.filterSubjects.get(0);
    }

    public @Nullable List<String> getFilterSubjects() {
        return this.filterSubjects;
    }

    public @Nullable List<String> getPriorityGroups() {
        return this.priorityGroups;
    }

    public boolean hasMultipleFilterSubjects() {
        return this.filterSubjects != null && this.filterSubjects.size() > 1;
    }

    public @NonNull ReplayPolicy getReplayPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.replayPolicy);
    }

    public long getRateLimit() {
        return ConsumerConfiguration.getOrUnsetUlong(this.rateLimit);
    }

    public long getMaxAckPending() {
        return ConsumerConfiguration.getOrUnset(this.maxAckPending);
    }

    public @Nullable String getSampleFrequency() {
        return this.sampleFrequency;
    }

    public @Nullable Duration getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public boolean isFlowControl() {
        return Boolean.TRUE.equals(this.flowControl);
    }

    public long getMaxPullWaiting() {
        return ConsumerConfiguration.getOrUnset(this.maxPullWaiting);
    }

    public boolean isHeadersOnly() {
        return this.headersOnly != null && this.headersOnly != false;
    }

    public boolean isMemStorage() {
        return this.memStorage != null && this.memStorage != false;
    }

    public long getMaxBatch() {
        return ConsumerConfiguration.getOrUnset(this.maxBatch);
    }

    public long getMaxBytes() {
        return ConsumerConfiguration.getOrUnset(this.maxBytes);
    }

    public @Nullable Duration getMaxExpires() {
        return this.maxExpires;
    }

    public @Nullable Duration getInactiveThreshold() {
        return this.inactiveThreshold;
    }

    public @NonNull List<Duration> getBackoff() {
        return this.backoff == null ? Collections.emptyList() : this.backoff;
    }

    public @NonNull Map<String, String> getMetadata() {
        return this.metadata == null ? Collections.emptyMap() : this.metadata;
    }

    public int getNumReplicas() {
        return ConsumerConfiguration.getOrUnset(this.numReplicas);
    }

    public @Nullable ZonedDateTime getPauseUntil() {
        return this.pauseUntil;
    }

    public @NonNull PriorityPolicy getPriorityPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.priorityPolicy);
    }

    public boolean deliverPolicyWasSet() {
        return this.deliverPolicy != null;
    }

    public boolean ackPolicyWasSet() {
        return this.ackPolicy != null;
    }

    public boolean replayPolicyWasSet() {
        return this.replayPolicy != null;
    }

    public boolean startSeqWasSet() {
        return this.startSeq != null;
    }

    public boolean maxDeliverWasSet() {
        return this.maxDeliver != null;
    }

    public boolean rateLimitWasSet() {
        return this.rateLimit != null;
    }

    public boolean maxAckPendingWasSet() {
        return this.maxAckPending != null;
    }

    public boolean maxPullWaitingWasSet() {
        return this.maxPullWaiting != null;
    }

    public boolean maxBatchWasSet() {
        return this.maxBatch != null;
    }

    public boolean maxBytesWasSet() {
        return this.maxBytes != null;
    }

    public boolean flowControlWasSet() {
        return this.flowControl != null;
    }

    public boolean headersOnlyWasSet() {
        return this.headersOnly != null;
    }

    public boolean memStorageWasSet() {
        return this.memStorage != null;
    }

    public boolean numReplicasWasSet() {
        return this.numReplicas != null;
    }

    public boolean backoffWasSet() {
        return this.backoff != null;
    }

    public boolean metadataWasSet() {
        return this.metadata != null;
    }

    public boolean priorityPolicyWasSet() {
        return this.priorityPolicy != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConsumerConfiguration cc) {
        return cc == null ? new Builder() : new Builder(cc);
    }

    public String toString() {
        return "ConsumerConfiguration " + this.toJson();
    }

    protected static int getOrUnset(Integer val) {
        return val == null ? -1 : val;
    }

    protected static long getOrUnsetUlong(Long val) {
        return val == null || val < 0L ? 0L : val;
    }

    protected static Duration getOrUnset(Duration val) {
        return val == null ? DURATION_UNSET : val;
    }

    protected static Integer normalize(Long l, int min) {
        if (l == null) {
            return null;
        }
        if (l < (long)min) {
            return -1;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return l.intValue();
    }

    protected static Long normalizeUlong(Long u) {
        return u == null ? null : Long.valueOf(u <= 0L ? 0L : u);
    }

    protected static Duration normalize(Duration d) {
        return d == null ? null : (d.toNanos() <= 0L ? DURATION_UNSET : d);
    }

    protected static Duration normalizeDuration(long millis) {
        return millis <= 0L ? DURATION_UNSET : Duration.ofMillis(millis);
    }

    protected static DeliverPolicy GetOrDefault(DeliverPolicy p) {
        return p == null ? DEFAULT_DELIVER_POLICY : p;
    }

    protected static AckPolicy GetOrDefault(AckPolicy p) {
        return p == null ? DEFAULT_ACK_POLICY : p;
    }

    protected static ReplayPolicy GetOrDefault(ReplayPolicy p) {
        return p == null ? DEFAULT_REPLAY_POLICY : p;
    }

    protected static PriorityPolicy GetOrDefault(PriorityPolicy p) {
        return p == null ? DEFAULT_PRIORITY_POLICY : p;
    }

    public static class Builder {
        private DeliverPolicy deliverPolicy;
        private AckPolicy ackPolicy;
        private ReplayPolicy replayPolicy;
        private String description;
        private String durable;
        private String name;
        private String deliverSubject;
        private String deliverGroup;
        private String sampleFrequency;
        private ZonedDateTime startTime;
        private Duration ackWait;
        private Duration idleHeartbeat;
        private Duration maxExpires;
        private Duration inactiveThreshold;
        private Long startSeq;
        private Integer maxDeliver;
        private Long rateLimit;
        private Integer maxAckPending;
        private Integer maxPullWaiting;
        private Integer maxBatch;
        private Integer maxBytes;
        private Integer numReplicas;
        private ZonedDateTime pauseUntil;
        private Boolean flowControl;
        private Boolean headersOnly;
        private Boolean memStorage;
        private List<Duration> backoff;
        private Map<String, String> metadata;
        private List<String> filterSubjects;
        private List<String> priorityGroups;
        private PriorityPolicy priorityPolicy;

        public Builder() {
        }

        public Builder(ConsumerConfiguration cc) {
            if (cc != null) {
                this.deliverPolicy = cc.deliverPolicy;
                this.ackPolicy = cc.ackPolicy;
                this.replayPolicy = cc.replayPolicy;
                this.description = cc.description;
                this.durable = cc.durable;
                this.name = cc.name;
                this.deliverSubject = cc.deliverSubject;
                this.deliverGroup = cc.deliverGroup;
                this.sampleFrequency = cc.sampleFrequency;
                this.startTime = cc.startTime;
                this.ackWait = cc.ackWait;
                this.idleHeartbeat = cc.idleHeartbeat;
                this.maxExpires = cc.maxExpires;
                this.inactiveThreshold = cc.inactiveThreshold;
                this.startSeq = cc.startSeq;
                this.maxDeliver = cc.maxDeliver;
                this.rateLimit = cc.rateLimit;
                this.maxAckPending = cc.maxAckPending;
                this.maxPullWaiting = cc.maxPullWaiting;
                this.maxBatch = cc.maxBatch;
                this.maxBytes = cc.maxBytes;
                this.numReplicas = cc.numReplicas;
                this.pauseUntil = cc.pauseUntil;
                this.flowControl = cc.flowControl;
                this.headersOnly = cc.headersOnly;
                this.memStorage = cc.memStorage;
                if (cc.backoff != null) {
                    this.backoff = new ArrayList<Duration>(cc.backoff);
                }
                if (cc.metadata != null) {
                    this.metadata = new HashMap<String, String>(cc.metadata);
                }
                if (cc.filterSubjects != null) {
                    this.filterSubjects = new ArrayList<String>(cc.filterSubjects);
                }
                if (cc.priorityGroups != null) {
                    this.priorityGroups = new ArrayList<String>(cc.priorityGroups);
                }
                this.priorityPolicy = cc.priorityPolicy;
            }
        }

        public Builder json(String json) throws JsonParseException {
            return this.jsonValue(JsonParser.parse(json));
        }

        public Builder jsonValue(JsonValue jsonValue) {
            this.deliverPolicy(DeliverPolicy.get(JsonValueUtils.readString(jsonValue, "deliver_policy")));
            this.ackPolicy(AckPolicy.get(JsonValueUtils.readString(jsonValue, "ack_policy")));
            this.replayPolicy(ReplayPolicy.get(JsonValueUtils.readString(jsonValue, "replay_policy")));
            this.description(JsonValueUtils.readString(jsonValue, "description"));
            this.durable(JsonValueUtils.readString(jsonValue, "durable_name"));
            this.name(JsonValueUtils.readString(jsonValue, "name"));
            this.deliverSubject(JsonValueUtils.readString(jsonValue, "deliver_subject"));
            this.deliverGroup(JsonValueUtils.readString(jsonValue, "deliver_group"));
            this.sampleFrequency(JsonValueUtils.readString(jsonValue, "sample_freq"));
            this.startTime(JsonValueUtils.readDate(jsonValue, "opt_start_time"));
            this.ackWait(JsonValueUtils.readNanos(jsonValue, "ack_wait"));
            this.maxExpires(JsonValueUtils.readNanos(jsonValue, "max_expires"));
            this.inactiveThreshold(JsonValueUtils.readNanos(jsonValue, "inactive_threshold"));
            this.startSequence(JsonValueUtils.readLong(jsonValue, "opt_start_seq"));
            this.maxDeliver(JsonValueUtils.readLong(jsonValue, "max_deliver", -1L));
            this.rateLimit(JsonValueUtils.readLong(jsonValue, "rate_limit_bps"));
            this.maxAckPending(JsonValueUtils.readLong(jsonValue, "max_ack_pending"));
            this.maxPullWaiting(JsonValueUtils.readLong(jsonValue, "max_waiting"));
            this.maxBatch(JsonValueUtils.readLong(jsonValue, "max_batch"));
            this.maxBytes(JsonValueUtils.readLong(jsonValue, "max_bytes"));
            Integer r = JsonValueUtils.readInteger(jsonValue, "num_replicas");
            if (r != null) {
                if (r == 0) {
                    this.numReplicas = 0;
                } else {
                    this.numReplicas(r);
                }
            }
            this.pauseUntil(JsonValueUtils.readDate(jsonValue, "pause_until"));
            Duration idleHeartbeat = JsonValueUtils.readNanos(jsonValue, "idle_heartbeat");
            if (idleHeartbeat != null) {
                if (JsonValueUtils.readBoolean(jsonValue, "flow_control", false).booleanValue()) {
                    this.flowControl(idleHeartbeat);
                } else {
                    this.idleHeartbeat(idleHeartbeat);
                }
            }
            this.headersOnly(JsonValueUtils.readBoolean(jsonValue, "headers_only", null));
            this.memStorage(JsonValueUtils.readBoolean(jsonValue, "mem_storage", null));
            this.backoff(JsonValueUtils.readNanosList(jsonValue, "backoff", false).toArray(new Duration[0]));
            this.metadata(JsonValueUtils.readStringStringMap(jsonValue, "metadata"));
            String fs = Validator.emptyAsNull(JsonValueUtils.readString(jsonValue, "filter_subject"));
            if (fs == null) {
                this.filterSubjects(JsonValueUtils.readOptionalStringList(jsonValue, "filter_subjects"));
            } else {
                this.filterSubject(fs);
            }
            this.priorityGroups(JsonValueUtils.readOptionalStringList(jsonValue, "priority_groups"));
            this.priorityPolicy(PriorityPolicy.get(JsonValueUtils.readString(jsonValue, "priority_policy")));
            return this;
        }

        public Builder description(String description) {
            this.description = Validator.emptyAsNull(description);
            return this;
        }

        public Builder durable(String durable) {
            this.durable = Validator.validateDurable(durable, false);
            return this;
        }

        public Builder name(String name) {
            this.name = Validator.validateConsumerName(name, false);
            return this;
        }

        public Builder deliverPolicy(DeliverPolicy policy) {
            this.deliverPolicy = policy;
            return this;
        }

        public Builder deliverSubject(String subject) {
            this.deliverSubject = Validator.emptyAsNull(subject);
            return this;
        }

        public Builder deliverGroup(String group) {
            this.deliverGroup = Validator.emptyAsNull(group);
            return this;
        }

        public Builder startSequence(Long sequence) {
            this.startSeq = ConsumerConfiguration.normalizeUlong(sequence);
            return this;
        }

        public Builder startSequence(long sequence) {
            this.startSeq = ConsumerConfiguration.normalizeUlong(sequence);
            return this;
        }

        public Builder startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder ackPolicy(AckPolicy policy) {
            this.ackPolicy = policy;
            return this;
        }

        public Builder ackWait(Duration timeout) {
            this.ackWait = ConsumerConfiguration.normalize(timeout);
            return this;
        }

        public Builder ackWait(long timeoutMillis) {
            this.ackWait = ConsumerConfiguration.normalizeDuration(timeoutMillis);
            return this;
        }

        public Builder maxDeliver(Long maxDeliver) {
            this.maxDeliver = ConsumerConfiguration.normalize(maxDeliver, 1);
            return this;
        }

        public Builder maxDeliver(long maxDeliver) {
            this.maxDeliver = ConsumerConfiguration.normalize(maxDeliver, 1);
            return this;
        }

        public Builder filterSubject(String filterSubject) {
            this.filterSubjects = Validator.nullOrEmpty(filterSubject) ? null : Collections.singletonList(filterSubject);
            return this;
        }

        public Builder filterSubjects(String ... filterSubjects) {
            return this.filterSubjects(Arrays.asList(filterSubjects));
        }

        public Builder filterSubjects(List<String> filterSubjects) {
            this.filterSubjects = new ArrayList<String>();
            if (filterSubjects != null) {
                for (String fs : filterSubjects) {
                    if (Validator.nullOrEmpty(fs)) continue;
                    this.filterSubjects.add(fs);
                }
            }
            if (this.filterSubjects.isEmpty()) {
                this.filterSubjects = null;
            }
            return this;
        }

        public Builder replayPolicy(ReplayPolicy policy) {
            this.replayPolicy = policy;
            return this;
        }

        public Builder sampleFrequency(String frequency) {
            this.sampleFrequency = Validator.emptyAsNull(frequency);
            return this;
        }

        public Builder rateLimit(Long bitsPerSecond) {
            this.rateLimit = ConsumerConfiguration.normalizeUlong(bitsPerSecond);
            return this;
        }

        public Builder rateLimit(long bitsPerSecond) {
            this.rateLimit = ConsumerConfiguration.normalizeUlong(bitsPerSecond);
            return this;
        }

        public Builder maxAckPending(Long maxAckPending) {
            this.maxAckPending = ConsumerConfiguration.normalize(maxAckPending, 0);
            return this;
        }

        public Builder maxAckPending(long maxAckPending) {
            this.maxAckPending = ConsumerConfiguration.normalize(maxAckPending, 0);
            return this;
        }

        public Builder idleHeartbeat(Duration idleHeartbeat) {
            if (idleHeartbeat == null) {
                this.idleHeartbeat = null;
            } else {
                long nanos = idleHeartbeat.toNanos();
                if (nanos <= 0L) {
                    this.idleHeartbeat = DURATION_UNSET;
                } else {
                    if (nanos < MIN_IDLE_HEARTBEAT_NANOS) {
                        throw new IllegalArgumentException("Duration must be greater than or equal to " + MIN_IDLE_HEARTBEAT_NANOS + " nanos.");
                    }
                    this.idleHeartbeat = idleHeartbeat;
                }
            }
            return this;
        }

        public Builder idleHeartbeat(long idleHeartbeatMillis) {
            if (idleHeartbeatMillis <= 0L) {
                this.idleHeartbeat = DURATION_UNSET;
            } else {
                if (idleHeartbeatMillis < MIN_IDLE_HEARTBEAT_MILLIS) {
                    throw new IllegalArgumentException("Duration must be greater than or equal to " + MIN_IDLE_HEARTBEAT_MILLIS + " milliseconds.");
                }
                this.idleHeartbeat = Duration.ofMillis(idleHeartbeatMillis);
            }
            return this;
        }

        public Builder flowControl(Duration idleHeartbeat) {
            this.flowControl = true;
            return this.idleHeartbeat(idleHeartbeat);
        }

        public Builder flowControl(long idleHeartbeatMillis) {
            this.flowControl = true;
            return this.idleHeartbeat(idleHeartbeatMillis);
        }

        public Builder maxExpires(Duration maxExpires) {
            this.maxExpires = ConsumerConfiguration.normalize(maxExpires);
            return this;
        }

        public Builder maxExpires(long maxExpires) {
            this.maxExpires = ConsumerConfiguration.normalizeDuration(maxExpires);
            return this;
        }

        public Builder inactiveThreshold(Duration inactiveThreshold) {
            this.inactiveThreshold = ConsumerConfiguration.normalize(inactiveThreshold);
            return this;
        }

        public Builder inactiveThreshold(long inactiveThreshold) {
            this.inactiveThreshold = ConsumerConfiguration.normalizeDuration(inactiveThreshold);
            return this;
        }

        public Builder maxPullWaiting(Long maxPullWaiting) {
            this.maxPullWaiting = ConsumerConfiguration.normalize(maxPullWaiting, 0);
            return this;
        }

        public Builder maxPullWaiting(long maxPullWaiting) {
            this.maxPullWaiting = ConsumerConfiguration.normalize(maxPullWaiting, 0);
            return this;
        }

        public Builder maxBatch(Long maxBatch) {
            this.maxBatch = ConsumerConfiguration.normalize(maxBatch, 0);
            return this;
        }

        public Builder maxBatch(long maxBatch) {
            this.maxBatch = ConsumerConfiguration.normalize(maxBatch, 0);
            return this;
        }

        public Builder maxBytes(Long maxBytes) {
            this.maxBytes = ConsumerConfiguration.normalize(maxBytes, 0);
            return this;
        }

        public Builder maxBytes(long maxBytes) {
            this.maxBytes = ConsumerConfiguration.normalize(maxBytes, 0);
            return this;
        }

        public Builder numReplicas(Integer numReplicas) {
            this.numReplicas = numReplicas == null ? null : Integer.valueOf(Validator.validateNumberOfReplicas(numReplicas));
            return this;
        }

        public Builder pauseUntil(ZonedDateTime pauseUntil) {
            this.pauseUntil = pauseUntil;
            return this;
        }

        public Builder headersOnly(Boolean headersOnly) {
            this.headersOnly = headersOnly;
            return this;
        }

        public Builder memStorage(Boolean memStorage) {
            this.memStorage = memStorage;
            return this;
        }

        public Builder backoff(Duration ... backoffs) {
            if (backoffs == null || backoffs.length == 1 && backoffs[0] == null) {
                this.backoff = null;
            } else {
                this.backoff = new ArrayList<Duration>();
                for (Duration d : backoffs) {
                    if (d == null) continue;
                    if (d.toNanos() < 1L) {
                        throw new IllegalArgumentException("Backoff cannot be less than 1");
                    }
                    this.backoff.add(d);
                }
            }
            return this;
        }

        public Builder backoff(long ... backoffsMillis) {
            if (backoffsMillis == null) {
                this.backoff = null;
            } else {
                this.backoff = new ArrayList<Duration>();
                for (long ms : backoffsMillis) {
                    if (ms < 1L) {
                        throw new IllegalArgumentException("Backoff cannot be less than 1");
                    }
                    this.backoff.add(Duration.ofMillis(ms));
                }
            }
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata == null || metadata.isEmpty() ? null : new HashMap<String, String>(metadata);
            return this;
        }

        public Builder priorityGroups(String ... priorityGroups) {
            return this.priorityGroups(Arrays.asList(priorityGroups));
        }

        public Builder priorityGroups(List<String> priorityGroups) {
            this.priorityGroups = new ArrayList<String>();
            if (priorityGroups != null) {
                for (String pg : priorityGroups) {
                    if (Validator.nullOrEmpty(pg)) continue;
                    this.priorityGroups.add(pg);
                }
            }
            if (this.priorityGroups.isEmpty()) {
                this.priorityGroups = null;
            }
            return this;
        }

        public Builder priorityPolicy(PriorityPolicy policy) {
            this.priorityPolicy = policy;
            return this;
        }

        public ConsumerConfiguration build() {
            Validator.validateMustMatchIfBothSupplied(this.name, this.durable, NatsJetStreamClientError.JsConsumerNameDurableMismatch);
            return new ConsumerConfiguration(this);
        }

        public PushSubscribeOptions buildPushSubscribeOptions() {
            return ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(this.build())).build();
        }

        public PushSubscribeOptions buildPushSubscribeOptions(String stream) {
            return ((PushSubscribeOptions.Builder)((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(this.build())).stream(stream)).build();
        }

        public PullSubscribeOptions buildPullSubscribeOptions() {
            return ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().configuration(this.build())).build();
        }

        public PullSubscribeOptions buildPullSubscribeOptions(String stream) {
            return ((PullSubscribeOptions.Builder)((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().configuration(this.build())).stream(stream)).build();
        }
    }
}

