/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.StreamInfo;
import io.nats.client.api.StreamInfoOptions;
import io.nats.client.impl.ListRequestEngine;
import io.nats.client.support.JsonUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class StreamInfoReader {
    private StreamInfo streamInfo;
    private ListRequestEngine engine = new ListRequestEngine();

    StreamInfoReader() {
    }

    void process(@NonNull Message msg) throws JetStreamApiException {
        this.engine = new ListRequestEngine(msg);
        StreamInfo si = new StreamInfo(msg);
        if (this.streamInfo == null) {
            this.streamInfo = si;
        } else {
            this.streamInfo.getStreamState().getSubjects().addAll(si.getStreamState().getSubjects());
        }
    }

    boolean hasMore() {
        return this.engine.hasMore();
    }

    byte @NonNull [] nextJson(@Nullable StreamInfoOptions options) {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "offset", this.engine.nextOffset());
        if (options != null) {
            JsonUtils.addField(sb, "subjects_filter", options.getSubjectsFilter());
            JsonUtils.addFldWhenTrue(sb, "deleted_details", options.isDeletedDetails());
        }
        return JsonUtils.endJson(sb).toString().getBytes();
    }

    StreamInfo getStreamInfo() {
        return this.streamInfo;
    }
}

