/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.NatsPublishableMessage;
import io.nats.client.support.ByteArrayBuilder;

class ProtocolMessage
extends NatsPublishableMessage {
    final boolean filterOnStop;

    ProtocolMessage(ByteArrayBuilder babProtocol, boolean filterOnStop) {
        super(false);
        this.protocolBab = babProtocol;
        this.sizeInBytes = this.controlLineLength = this.protocolBab.length() + 2;
        this.filterOnStop = filterOnStop;
    }

    ProtocolMessage(byte[] protocol) {
        super(false);
        this.protocolBab = new ByteArrayBuilder(protocol);
        this.sizeInBytes = this.controlLineLength = this.protocolBab.length() + 2;
        this.filterOnStop = true;
    }

    ProtocolMessage(ProtocolMessage pm) {
        super(false);
        this.protocolBab = pm.protocolBab;
        this.sizeInBytes = this.controlLineLength = pm.sizeInBytes;
        this.filterOnStop = pm.filterOnStop;
    }

    @Override
    boolean isProtocol() {
        return true;
    }

    @Override
    boolean isProtocolFilterOnStop() {
        return this.filterOnStop;
    }

    @Override
    int copyNotEmptyHeaders(int destPosition, byte[] dest) {
        return 0;
    }
}

