/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import org.jspecify.annotations.NonNull;

public class BaseConsumeOptions
implements JsonSerializable {
    public static final int DEFAULT_MESSAGE_COUNT = 500;
    public static final int DEFAULT_MESSAGE_COUNT_WHEN_BYTES = 1000000;
    public static final int DEFAULT_THRESHOLD_PERCENT = 25;
    public static final long DEFAULT_EXPIRES_IN_MILLIS = 30000L;
    public static final long MIN_EXPIRES_MILLS = 1000L;
    public static final long MAX_HEARTBEAT_MILLIS = 30000L;
    public static final int MAX_IDLE_HEARTBEAT_PERCENT = 50;
    protected final int messages;
    protected final long bytes;
    protected final long expiresIn;
    protected final int thresholdPercent;
    protected final long idleHeartbeat;
    protected final String group;
    protected final int priority;
    protected final long minPending;
    protected final long minAckPending;
    protected final boolean raiseStatusWarnings;

    protected BaseConsumeOptions(Builder<?, ?> b) {
        this.bytes = b.bytes;
        this.messages = this.bytes > 0L ? (b.messages < 0 ? 1000000 : b.messages) : (b.messages < 0 ? 500 : b.messages);
        this.expiresIn = b.expiresIn;
        this.thresholdPercent = b.thresholdPercent;
        this.idleHeartbeat = Math.min(30000L, this.expiresIn * 50L / 100L);
        this.group = b.group;
        this.priority = b.priority;
        this.minPending = b.minPending;
        this.minAckPending = b.minAckPending;
        this.raiseStatusWarnings = b.raiseStatusWarnings;
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "messages", this.messages);
        JsonUtils.addField(sb, "bytes", this.bytes);
        JsonUtils.addField(sb, "expires_in", this.expiresIn);
        JsonUtils.addField(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addField(sb, "threshold_percent", this.thresholdPercent);
        JsonUtils.addField(sb, "group", this.group);
        JsonUtils.addField(sb, "priority", this.priority);
        JsonUtils.addField(sb, "min_pending", this.minPending);
        JsonUtils.addField(sb, "min_ack_pending", this.minAckPending);
        JsonUtils.addFldWhenTrue(sb, "raise_status_warnings", this.raiseStatusWarnings);
        this.subclassSpecificToJson(sb);
        return JsonUtils.endJson(sb).toString();
    }

    protected void subclassSpecificToJson(StringBuilder sb) {
    }

    public long getExpiresInMillis() {
        return this.expiresIn;
    }

    public long getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public int getThresholdPercent() {
        return this.thresholdPercent;
    }

    public boolean raiseStatusWarnings() {
        return this.raiseStatusWarnings;
    }

    public String getGroup() {
        return this.group;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getMinPending() {
        return this.minPending;
    }

    public long getMinAckPending() {
        return this.minAckPending;
    }

    protected static abstract class Builder<B, CO> {
        protected int messages = -1;
        protected long bytes = 0L;
        protected int thresholdPercent = 25;
        protected long expiresIn = 30000L;
        protected boolean raiseStatusWarnings = false;
        protected String group;
        protected int priority;
        protected long minPending = -1L;
        protected long minAckPending = -1L;

        protected Builder() {
        }

        protected abstract B getThis();

        public B json(String json) throws JsonParseException {
            return this.jsonValue(JsonParser.parse(json));
        }

        public B jsonValue(JsonValue jsonValue) {
            this.messages(JsonValueUtils.readInteger(jsonValue, "messages", -1));
            this.bytes(JsonValueUtils.readLong(jsonValue, "bytes", -1L));
            this.expiresIn(JsonValueUtils.readLong(jsonValue, "expires_in", 30000L));
            this.thresholdPercent(JsonValueUtils.readInteger(jsonValue, "threshold_percent", -1));
            this.raiseStatusWarnings(JsonValueUtils.readBoolean(jsonValue, "raise_status_warnings", false));
            this.group(JsonValueUtils.readStringEmptyAsNull(jsonValue, "group"));
            this.priority(JsonValueUtils.readInteger(jsonValue, "priority", 0));
            this.minPending(JsonValueUtils.readLong(jsonValue, "min_pending", -1L));
            this.minAckPending(JsonValueUtils.readLong(jsonValue, "min_ack_pending", -1L));
            return this.getThis();
        }

        protected B messages(int messages) {
            this.messages = messages < 1 ? -1 : messages;
            return this.getThis();
        }

        protected B bytes(long bytes) {
            this.bytes = bytes < 1L ? 0L : bytes;
            return this.getThis();
        }

        public B expiresIn(long expiresInMillis) {
            if (expiresInMillis < 1L) {
                this.expiresIn = 30000L;
            } else {
                if (expiresInMillis < 1000L) {
                    throw new IllegalArgumentException("Expires must be greater than or equal to 1000");
                }
                this.expiresIn = expiresInMillis;
            }
            return this.getThis();
        }

        public B thresholdPercent(int thresholdPercent) {
            this.thresholdPercent = thresholdPercent < 1 ? 25 : Math.min(100, thresholdPercent);
            return this.getThis();
        }

        public B raiseStatusWarnings() {
            this.raiseStatusWarnings = true;
            return this.getThis();
        }

        public B raiseStatusWarnings(boolean raiseStatusWarnings) {
            this.raiseStatusWarnings = raiseStatusWarnings;
            return this.getThis();
        }

        public B group(String group) {
            this.group = group;
            return this.getThis();
        }

        public B priority(int priority) {
            this.priority = priority;
            return this.getThis();
        }

        public B minPending(long minPending) {
            this.minPending = minPending < 1L ? -1L : minPending;
            return this.getThis();
        }

        public B minAckPending(long minAckPending) {
            this.minAckPending = minAckPending < 1L ? -1L : minAckPending;
            return this.getThis();
        }

        public abstract CO build();
    }
}

