/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.time.Duration;

public class ForceReconnectOptions {
    public static final ForceReconnectOptions DEFAULT_INSTANCE = ForceReconnectOptions.builder().build();
    public static final ForceReconnectOptions FORCE_CLOSE_INSTANCE = ForceReconnectOptions.builder().forceClose().build();
    private final boolean forceClose;
    private final Duration flushWait;

    private ForceReconnectOptions(Builder b) {
        this.forceClose = b.forceClose;
        this.flushWait = b.flushWait;
    }

    public boolean isForceClose() {
        return this.forceClose;
    }

    public boolean isFlush() {
        return this.flushWait != null;
    }

    public Duration getFlushWait() {
        return this.flushWait;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        boolean forceClose = false;
        Duration flushWait;

        public Builder forceClose() {
            this.forceClose = true;
            return this;
        }

        public Builder flush(Duration flushWait) {
            this.flushWait = flushWait == null || flushWait.toMillis() < 1L ? null : flushWait;
            return this;
        }

        public Builder flush(long flushWaitMillis) {
            this.flushWait = flushWaitMillis > 0L ? Duration.ofMillis(flushWaitMillis) : null;
            return this;
        }

        public ForceReconnectOptions build() {
            return new ForceReconnectOptions(this);
        }
    }
}

