/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.Replica;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class ClusterInfo {
    private final String name;
    private final String raftGroup;
    private final String leader;
    private final ZonedDateTime leaderSince;
    private final boolean systemAccount;
    private final String trafficAccount;
    private final List<Replica> replicas;

    static ClusterInfo optionalInstance(JsonValue v) {
        return v == null ? null : new ClusterInfo(v);
    }

    ClusterInfo(JsonValue v) {
        this.name = JsonValueUtils.readString(v, "name");
        this.raftGroup = JsonValueUtils.readString(v, "raft_group");
        this.leader = JsonValueUtils.readString(v, "leader");
        this.leaderSince = JsonValueUtils.readDate(v, "leader_since");
        this.systemAccount = JsonValueUtils.readBoolean(v, "system_account");
        this.trafficAccount = JsonValueUtils.readString(v, "traffic_account");
        this.replicas = Replica.optionalListOf(JsonValueUtils.readValue(v, "replicas"));
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getRaftGroup() {
        return this.raftGroup;
    }

    public @Nullable String getLeader() {
        return this.leader;
    }

    public @Nullable ZonedDateTime getLeaderSince() {
        return this.leaderSince;
    }

    public boolean isSystemAccount() {
        return this.systemAccount;
    }

    public @Nullable String getTrafficAccount() {
        return this.trafficAccount;
    }

    public @Nullable List<Replica> getReplicas() {
        return this.replicas;
    }

    public String toString() {
        return "ClusterInfo{name='" + this.name + '\'' + ", raftGroup='" + this.raftGroup + '\'' + ", leader='" + this.leader + '\'' + ", leaderSince=" + this.leaderSince + ", systemAccount=" + this.systemAccount + ", trafficAccount=" + this.trafficAccount + ", replicas=" + this.replicas + '}';
    }
}

