/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.CompressionOption;
import io.nats.client.api.Placement;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class FeatureConfiguration
implements JsonSerializable {
    protected static final CompressionOption JS_COMPRESSION_YES = CompressionOption.S2;
    protected static final CompressionOption JS_COMPRESSION_NO = CompressionOption.None;
    protected final StreamConfiguration sc;
    protected final String bucketName;

    @Override
    public @NonNull String toJson() {
        return this.toJsonValue().toString();
    }

    @Override
    public @NonNull JsonValue toJsonValue() {
        JsonValueUtils.MapBuilder mb = new JsonValueUtils.MapBuilder();
        mb.put("name", this.bucketName);
        mb.put("description", this.getDescription());
        mb.put("maxBucketSize", this.getMaxBucketSize());
        mb.put("ttl", this.getTtl());
        mb.put("storageType", (Object)this.getStorageType());
        mb.put("replicas", this.getReplicas());
        mb.put("placement", this.getPlacement());
        mb.put("isCompressed", this.isCompressed());
        mb.put("metaData", this.getMetadata());
        return mb.toJsonValue();
    }

    public FeatureConfiguration(StreamConfiguration sc, String bucketName) {
        this.sc = sc;
        this.bucketName = bucketName;
    }

    public @NonNull StreamConfiguration getBackingConfig() {
        return this.sc;
    }

    public @NonNull String getBucketName() {
        return this.bucketName;
    }

    public @Nullable String getDescription() {
        return this.sc.getDescription();
    }

    public long getMaxBucketSize() {
        return this.sc.getMaxBytes();
    }

    public @Nullable Duration getTtl() {
        return this.sc.getMaxAge();
    }

    public @Nullable StorageType getStorageType() {
        return this.sc.getStorageType();
    }

    public int getReplicas() {
        return this.sc.getReplicas();
    }

    public @Nullable Placement getPlacement() {
        return this.sc.getPlacement();
    }

    public boolean isCompressed() {
        return this.sc.getCompressionOption() == JS_COMPRESSION_YES;
    }

    public @Nullable Map<String, String> getMetadata() {
        return this.sc.getMetadata();
    }

    protected static abstract class Builder<B, FC> {
        protected String name;
        protected Duration ttl = Duration.ZERO;
        protected StreamConfiguration.Builder scBuilder;

        protected Builder() {
        }

        protected abstract B getThis();

        protected B name(String name) {
            this.name = Validator.validateBucketName(name, true);
            return this.getThis();
        }

        protected B description(String description) {
            this.scBuilder.description(description);
            return this.getThis();
        }

        protected B maxBucketSize(long maxBucketSize) {
            this.scBuilder.maxBytes(Validator.validateMaxBucketBytes(maxBucketSize));
            return this.getThis();
        }

        protected B ttl(Duration ttl) {
            this.ttl = ttl == null ? Duration.ZERO : ttl;
            this.scBuilder.maxAge(this.ttl);
            return this.getThis();
        }

        protected B storageType(StorageType storageType) {
            this.scBuilder.storageType(storageType);
            return this.getThis();
        }

        protected B replicas(int replicas) {
            this.scBuilder.replicas(replicas);
            return this.getThis();
        }

        protected B placement(Placement placement) {
            this.scBuilder.placement(placement);
            return this.getThis();
        }

        protected B compression(boolean compression) {
            this.scBuilder.compressionOption(compression ? JS_COMPRESSION_YES : JS_COMPRESSION_NO);
            return this.getThis();
        }

        public B metadata(Map<String, String> metadata) {
            this.scBuilder.metadata(metadata);
            return this.getThis();
        }

        public abstract FC build();
    }
}

