/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import org.jspecify.annotations.NonNull;

public class Republish
implements JsonSerializable {
    private final String source;
    private final String destination;
    private final boolean headersOnly;

    static Republish optionalInstance(JsonValue vRepublish) {
        return vRepublish == null ? null : new Republish(vRepublish);
    }

    Republish(JsonValue vRepublish) {
        this.source = JsonValueUtils.readString(vRepublish, "src");
        this.destination = JsonValueUtils.readString(vRepublish, "dest");
        this.headersOnly = JsonValueUtils.readBoolean(vRepublish, "headers_only");
    }

    public Republish(String source, String destination, boolean headersOnly) {
        Validator.required(source, "Source");
        Validator.required(destination, "Destination");
        this.source = source;
        this.destination = destination;
        this.headersOnly = headersOnly;
    }

    public @NonNull String getSource() {
        return this.source;
    }

    public @NonNull String getDestination() {
        return this.destination;
    }

    public boolean isHeadersOnly() {
        return this.headersOnly;
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "src", this.source);
        JsonUtils.addField(sb, "dest", this.destination);
        JsonUtils.addFldWhenTrue(sb, "headers_only", this.headersOnly);
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String source;
        private String destination;
        private boolean headersOnly;

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public Builder headersOnly(Boolean headersOnly) {
            this.headersOnly = headersOnly;
            return this;
        }

        public Republish build() {
            return new Republish(this.source, this.destination, this.headersOnly);
        }
    }
}

