/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.Error;
import io.nats.client.support.JsonValueUtils;
import java.nio.charset.StandardCharsets;

class ListRequestEngine
extends ApiResponse<ListRequestEngine> {
    private static final String OFFSET_JSON_START = "{\"offset\":";
    protected int total = Integer.MAX_VALUE;
    protected int limit = 0;
    protected int lastOffset = 0;

    ListRequestEngine() {
    }

    ListRequestEngine(Message msg) throws JetStreamApiException {
        super(msg);
        Error apiError = super.getErrorObject();
        if (apiError != null) {
            throw new JetStreamApiException(apiError);
        }
        this.total = JsonValueUtils.readInteger(this.jv, "total", -1);
        this.limit = JsonValueUtils.readInteger(this.jv, "limit", 0);
        this.lastOffset = JsonValueUtils.readInteger(this.jv, "offset", 0);
    }

    boolean hasMore() {
        return this.total > this.nextOffset();
    }

    private byte[] noFilterJson() {
        return (OFFSET_JSON_START + this.nextOffset() + "}").getBytes(StandardCharsets.UTF_8);
    }

    byte[] internalNextJson() {
        return this.hasMore() ? this.noFilterJson() : null;
    }

    byte[] internalNextJson(String fieldName, String filter) {
        if (this.hasMore()) {
            if (filter == null) {
                return this.noFilterJson();
            }
            return (OFFSET_JSON_START + this.nextOffset() + ",\"" + fieldName + "\":\"" + filter + "\"}").getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    int nextOffset() {
        return this.lastOffset + this.limit;
    }
}

