/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.NatsSystemClock;
import io.nats.client.PullRequestOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsMessageConsumerBase;
import io.nats.client.impl.PullManagerObserver;
import io.nats.client.impl.SimplifiedSubscriptionMaker;
import java.io.IOException;

class NatsFetchConsumer
extends NatsMessageConsumerBase
implements FetchConsumer,
PullManagerObserver {
    private final boolean isNoWaitNoExpires;
    private final long maxWaitNanos;
    private final String pullSubject;
    private long startNanos;

    NatsFetchConsumer(SimplifiedSubscriptionMaker subscriptionMaker, ConsumerInfo cachedConsumerInfo, FetchConsumeOptions fetchConsumeOptions) throws IOException, JetStreamApiException {
        super(cachedConsumerInfo);
        long inactiveThreshold;
        boolean isNoWait = fetchConsumeOptions.isNoWait();
        long expiresInMillis = fetchConsumeOptions.getExpiresInMillis();
        boolean bl = this.isNoWaitNoExpires = isNoWait && expiresInMillis == -1L;
        if (expiresInMillis == -1L) {
            this.maxWaitNanos = 1000000000L;
            inactiveThreshold = 1000L;
        } else {
            this.maxWaitNanos = expiresInMillis * 1000000L;
            inactiveThreshold = expiresInMillis * 110L / 100L;
        }
        NatsMessageConsumerBase.PinnablePullRequestOptions pro = new NatsMessageConsumerBase.PinnablePullRequestOptions(this.pmm == null ? null : this.pmm.currentPinId, PullRequestOptions.builder(fetchConsumeOptions.getMaxMessages()).maxBytes(fetchConsumeOptions.getMaxBytes()).expiresIn(expiresInMillis).idleHeartbeat(fetchConsumeOptions.getIdleHeartbeat()).noWait(isNoWait).group(fetchConsumeOptions.getGroup()).priority(fetchConsumeOptions.getPriority()).minPending(fetchConsumeOptions.getMinPending()).minAckPending(fetchConsumeOptions.getMinAckPending()));
        this.initSub(subscriptionMaker.subscribe(null, null, null, inactiveThreshold), false);
        this.pullSubject = this.sub._pull(pro, fetchConsumeOptions.raiseStatusWarnings(), this);
        this.startNanos = -1L;
    }

    @Override
    public void pendingUpdated() {
    }

    @Override
    public void heartbeatError() {
        this.fullClose();
    }

    @Override
    public Message nextMessage() throws InterruptedException, JetStreamStatusCheckedException {
        try {
            long timeLeftNanos;
            if (this.finished.get()) {
                return null;
            }
            if (this.pmm.noMorePending()) {
                Message m = this.sub._nextUnmanagedNoWait(this.pullSubject);
                if (m == null) {
                    this.fullClose();
                }
                return m;
            }
            if (this.startNanos == -1L) {
                this.startNanos = NatsSystemClock.nanoTime();
            }
            if ((timeLeftNanos = this.maxWaitNanos - (NatsSystemClock.nanoTime() - this.startNanos)) < 1000000L) {
                Message m = this.sub._nextUnmanagedNoWait(this.pullSubject);
                if (m == null) {
                    this.fullClose();
                }
                return m;
            }
            Message m = this.sub._nextUnmanaged(timeLeftNanos, this.pullSubject);
            if (m == null && this.isNoWaitNoExpires) {
                this.fullClose();
            }
            return m;
        }
        catch (JetStreamStatusException e) {
            throw new JetStreamStatusCheckedException(e);
        }
        catch (IllegalStateException i) {
            return null;
        }
    }
}

