/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.NatsPublishableMessage;
import io.nats.client.support.ByteArrayBuilder;

class ProtocolMessage
extends NatsPublishableMessage {
    final boolean filterOnStop;

    ProtocolMessage(ByteArrayBuilder babProtocol, boolean filterOnStop) {
        super(false);
        this.protocolBab = babProtocol;
        this.sizeInBytes = this.controlLineLength = this.protocolBab.length() + 2;
        this.filterOnStop = filterOnStop;
    }

    ProtocolMessage(byte[] protocol) {
        this(new ByteArrayBuilder(protocol), true);
    }

    ProtocolMessage(byte[] protocol, boolean filterOnStop) {
        this(new ByteArrayBuilder(protocol), filterOnStop);
    }

    ProtocolMessage(ProtocolMessage pm) {
        this(pm.protocolBab, pm.filterOnStop);
    }

    @Override
    boolean isProtocol() {
        return true;
    }

    @Override
    boolean isProtocolFilterOnStop() {
        return this.filterOnStop;
    }

    @Override
    int copyNotEmptyHeaders(int destPosition, byte[] dest) {
        return 0;
    }
}

