/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.impl.Headers;
import io.nats.client.support.NatsConstants;
import io.nats.client.support.Status;
import io.nats.client.support.Token;
import io.nats.client.support.TokenType;

public class IncomingHeadersProcessor {
    private final int serializedLength;
    private Headers headers;
    private Status inlineStatus;

    public IncomingHeadersProcessor(byte[] serialized) {
        if (serialized == null || serialized.length == 0) {
            throw new IllegalArgumentException("Serialized header cannot be null or empty.");
        }
        for (int x = 0; x < NatsConstants.HEADER_VERSION_BYTES_LEN; ++x) {
            if (serialized[x] == NatsConstants.HEADER_VERSION_BYTES[x]) continue;
            throw new IllegalArgumentException("Invalid header version");
        }
        this.serializedLength = serialized.length;
        Token terminus = new Token(serialized, this.serializedLength, this.serializedLength - 2, TokenType.CRLF);
        Token token = new Token(serialized, this.serializedLength, NatsConstants.HEADER_VERSION_BYTES_LEN, null);
        if (token.isType(TokenType.SPACE) && (token = this.initStatus(serialized, this.serializedLength, token)).samePoint(terminus)) {
            return;
        }
        if (!token.isType(TokenType.CRLF)) {
            throw new IllegalArgumentException("Invalid header composition");
        }
        this.initHeader(serialized, this.serializedLength, token);
    }

    public int getSerializedLength() {
        return this.serializedLength;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Status getStatus() {
        return this.inlineStatus;
    }

    private void initHeader(byte[] serialized, int len, Token tCrlf) {
        Token peek = new Token(serialized, len, tCrlf, null);
        while (peek.isType(TokenType.TEXT)) {
            Token tKey = new Token(serialized, len, tCrlf, TokenType.KEY);
            Token tVal = new Token(serialized, len, tKey, null);
            if (tVal.isType(TokenType.SPACE)) {
                tVal = new Token(serialized, len, tVal, null);
            }
            if (tVal.isType(TokenType.TEXT)) {
                tCrlf = new Token(serialized, len, tVal, TokenType.CRLF);
            } else {
                tVal.mustBe(TokenType.CRLF);
                tCrlf = tVal;
            }
            if (this.headers == null) {
                this.headers = new Headers();
            }
            this.headers.add(tKey.getValueCheckKnownKeys(), tVal.getValue());
            peek = new Token(serialized, len, tCrlf, null);
        }
        peek.mustBe(TokenType.CRLF);
    }

    private Token initStatus(byte[] serialized, int len, Token tSpace) {
        Token crlf;
        Token tCode = new Token(serialized, len, tSpace, TokenType.WORD);
        Token tVal = new Token(serialized, len, tCode, null);
        if (tVal.isType(TokenType.SPACE)) {
            tVal = new Token(serialized, len, tVal, TokenType.TEXT);
            crlf = new Token(serialized, len, tVal, TokenType.CRLF);
        } else {
            tVal.mustBe(TokenType.CRLF);
            crlf = tVal;
        }
        this.inlineStatus = new Status(tCode, tVal);
        return crlf;
    }
}

