/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class JsonParser {
    public static final String INVALID_VALUE = "Invalid value.";
    private static final boolean[] IS_DELIMITER = new boolean[128];
    private final StringBuilder workBuffer = new StringBuilder(64);
    private final char @NonNull [] json;
    private final boolean keepNulls;
    private final int len;
    private int idx;
    private int nextIdx;
    private char previous;
    private char current;
    private char next;

    public static @NonNull JsonValue parse(char @Nullable [] json) throws JsonParseException {
        return new JsonParser(json, 0, new Option[0]).parse();
    }

    public static @NonNull JsonValue parse(char @Nullable [] json, int startIndex) throws JsonParseException {
        return new JsonParser(json, startIndex, new Option[0]).parse();
    }

    public static @NonNull JsonValue parse(char @Nullable [] json, Option ... options) throws JsonParseException {
        return new JsonParser(json, 0, options).parse();
    }

    public static @NonNull JsonValue parse(char @Nullable [] json, int startIndex, Option ... options) throws JsonParseException {
        return new JsonParser(json, startIndex, options).parse();
    }

    public static @NonNull JsonValue parse(String json) throws JsonParseException {
        return new JsonParser(json.toCharArray(), 0, new Option[0]).parse();
    }

    public static @NonNull JsonValue parse(String json, int startIndex) throws JsonParseException {
        return new JsonParser(json.toCharArray(), startIndex, new Option[0]).parse();
    }

    public static @NonNull JsonValue parse(String json, Option ... options) throws JsonParseException {
        return new JsonParser(json.toCharArray(), 0, options).parse();
    }

    public static @NonNull JsonValue parse(String json, int startIndex, Option ... options) throws JsonParseException {
        return new JsonParser(json.toCharArray(), startIndex, options).parse();
    }

    public static @NonNull JsonValue parse(byte[] json) throws JsonParseException {
        return new JsonParser(JsonParser.bytesToChars(json), 0, new Option[0]).parse();
    }

    public static @NonNull JsonValue parse(byte[] json, int startIndex) throws JsonParseException {
        return new JsonParser(JsonParser.bytesToChars(json), startIndex, new Option[0]).parse();
    }

    public static @NonNull JsonValue parse(byte[] json, Option ... options) throws JsonParseException {
        return new JsonParser(JsonParser.bytesToChars(json), 0, options).parse();
    }

    public static @NonNull JsonValue parse(byte[] json, int startIndex, Option ... options) throws JsonParseException {
        return new JsonParser(JsonParser.bytesToChars(json), startIndex, options).parse();
    }

    public static @NonNull JsonValue parseUnchecked(char @Nullable [] json) {
        try {
            return JsonParser.parse(json);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(char @Nullable [] json, int startIndex) {
        try {
            return JsonParser.parse(json, startIndex);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(char @Nullable [] json, Option ... options) {
        try {
            return JsonParser.parse(json, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(char @Nullable [] json, int startIndex, Option ... options) {
        try {
            return JsonParser.parse(json, startIndex, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(String json) {
        try {
            return JsonParser.parse(json);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(String json, int startIndex) {
        try {
            return JsonParser.parse(json, startIndex);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(String json, Option ... options) {
        try {
            return JsonParser.parse(json, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(String json, int startIndex, Option ... options) {
        try {
            return JsonParser.parse(json, startIndex, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(byte[] json) {
        try {
            return JsonParser.parse(json);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(byte[] json, int startIndex) {
        try {
            return JsonParser.parse(json, startIndex);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(byte[] json, Option ... options) {
        try {
            return JsonParser.parse(json, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static @NonNull JsonValue parseUnchecked(byte[] json, int startIndex, Option ... options) {
        try {
            return JsonParser.parse(json, startIndex, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public JsonParser(char @Nullable [] json) {
        this(json, 0, new Option[0]);
    }

    public JsonParser(char @Nullable [] json, Option ... options) {
        this(json, 0, options);
    }

    public JsonParser(char @Nullable [] json, int startIndex, Option ... options) {
        boolean bl = this.keepNulls = options != null && options.length > 0;
        if (json == null) {
            this.json = new char[0];
            this.len = 0;
        } else {
            this.json = json;
            this.len = json.length;
        }
        this.idx = startIndex;
        if (startIndex < 0) {
            throw new IllegalArgumentException("Invalid start index.");
        }
        this.nextIdx = -1;
        this.previous = '\u0000';
        this.current = '\u0000';
        this.next = '\u0000';
    }

    public @NonNull JsonValue parse() throws JsonParseException {
        char c = this.peekToken();
        if (c == '\u0000') {
            return JsonValue.NULL;
        }
        return this.nextValue();
    }

    private JsonValue nextValue() throws JsonParseException {
        char c = this.peekToken();
        if (c == '\u0000') {
            throw new JsonParseException("Unexpected end of data.");
        }
        if (c == '\"') {
            this.nextToken();
            return new JsonValue(this.nextString());
        }
        if (c == '{') {
            this.nextToken();
            return new JsonValue(this.nextObject());
        }
        if (c == '[') {
            this.nextToken();
            return new JsonValue(this.nextArray());
        }
        return this.nextPrimitiveValue();
    }

    private List<JsonValue> nextArray() throws JsonParseException {
        ArrayList<JsonValue> list = new ArrayList<JsonValue>(8);
        char p = this.peekToken();
        while (p != ']') {
            if (p == ',') {
                this.nextToken();
            } else {
                list.add(this.nextValue());
            }
            p = this.peekToken();
        }
        this.nextToken();
        return list;
    }

    private JsonValue nextPrimitiveValue() throws JsonParseException {
        this.workBuffer.setLength(0);
        char c = this.peekToken();
        while (c >= ' ' && this.isNotDelimiter(c)) {
            this.workBuffer.append(this.nextToken());
            c = this.peekToken();
        }
        String string = this.workBuffer.toString();
        if (string.length() == 4) {
            if ("true".equals(string)) {
                return JsonValue.TRUE;
            }
            if ("null".equals(string)) {
                return JsonValue.NULL;
            }
        } else if (string.length() == 5 && "false".equals(string)) {
            return JsonValue.FALSE;
        }
        return this.asNumber(string);
    }

    private Map<String, JsonValue> nextObject() throws JsonParseException {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>(8);
        block9: while (true) {
            char c = this.nextToken();
            switch (c) {
                case '\u0000': {
                    throw new JsonParseException("Text must end with '}'");
                }
                case '}': {
                    return map;
                }
                case '[': 
                case '{': {
                    if (this.previous != '{') break;
                    throw new JsonParseException("Cannot directly nest another Object or Array.");
                }
            }
            String key = this.nextString();
            c = this.nextToken();
            if (c != ':') {
                throw new JsonParseException("Expected a ':' after a key.");
            }
            JsonValue value = this.nextValue();
            if (value != JsonValue.NULL || this.keepNulls) {
                map.put(key, value);
            }
            switch (this.nextToken()) {
                case ',': {
                    if (this.peekToken() != '}') continue block9;
                    return map;
                }
                case '}': {
                    return map;
                }
            }
            break;
        }
        throw new JsonParseException("Expected a ',' or '}'.");
    }

    private char nextToken() {
        this.peekToken();
        this.idx = this.nextIdx;
        this.nextIdx = -1;
        this.previous = this.current;
        this.current = this.next;
        this.next = '\u0000';
        return this.current;
    }

    private char nextChar() {
        this.previous = this.current;
        this.current = this.idx == this.len ? (char)'\u0000' : this.json[this.idx++];
        this.next = '\u0000';
        this.nextIdx = -1;
        return this.current;
    }

    private char peekToken() {
        if (this.nextIdx == -1) {
            this.nextIdx = this.idx;
            this.next = '\u0000';
            block3: while (this.nextIdx < this.len) {
                char c = this.json[this.nextIdx++];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                }
                this.next = c;
                return this.next;
            }
        }
        return this.next;
    }

    private String nextString() throws JsonParseException {
        this.workBuffer.setLength(0);
        block13: while (true) {
            char c = this.nextChar();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw new JsonParseException("Unterminated string.");
                }
                case '\\': {
                    c = this.nextChar();
                    switch (c) {
                        case 'b': {
                            this.workBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            this.workBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            this.workBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            this.workBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            this.workBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            this.workBuffer.append(this.parseU());
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            this.workBuffer.append(c);
                            continue block13;
                        }
                    }
                    throw new JsonParseException("Illegal escape.");
                }
            }
            if (c == '\"') {
                return this.workBuffer.toString();
            }
            this.workBuffer.append(c);
        }
    }

    private char[] parseU() throws JsonParseException {
        int code = 0;
        for (int i = 0; i < 4; ++i) {
            int digit;
            char c = this.nextToken();
            if (c == '\u0000') {
                throw new JsonParseException("Illegal escape.");
            }
            if (c >= '0' && c <= '9') {
                digit = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                digit = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                digit = c - 97 + 10;
            } else {
                throw new JsonParseException("Illegal escape.");
            }
            code = code << 4 | digit;
        }
        return Character.toChars(code);
    }

    private JsonValue asNumber(String val) throws JsonParseException {
        char initial = val.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            char at1;
            if (JsonParser.isDecimalNotation(val)) {
                try {
                    BigDecimal bd = new BigDecimal(val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return new JsonValue(-0.0);
                    }
                    return new JsonValue(bd);
                }
                catch (NumberFormatException retryAsDouble) {
                    try {
                        double d = Double.parseDouble(val);
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            throw new JsonParseException(INVALID_VALUE);
                        }
                        return new JsonValue(d);
                    }
                    catch (NumberFormatException ignore) {
                        throw new JsonParseException(INVALID_VALUE);
                    }
                }
            }
            if (initial == '0' && val.length() > 1) {
                at1 = val.charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new JsonParseException(INVALID_VALUE);
                }
            } else if (initial == '-' && val.length() > 2) {
                at1 = val.charAt(1);
                char at2 = val.charAt(2);
                if (at1 == '0' && at2 >= '0' && at2 <= '9') {
                    throw new JsonParseException(INVALID_VALUE);
                }
            }
            try {
                long longVal = Long.parseLong(val);
                if (longVal >= Integer.MIN_VALUE && longVal <= Integer.MAX_VALUE) {
                    return new JsonValue((int)longVal);
                }
                return new JsonValue(longVal);
            }
            catch (NumberFormatException e) {
                try {
                    BigInteger bi = new BigInteger(val);
                    return new JsonValue(bi);
                }
                catch (NumberFormatException ex) {
                    throw new JsonParseException(INVALID_VALUE);
                }
            }
        }
        throw new JsonParseException(INVALID_VALUE);
    }

    static boolean isDecimalNotation(String val) {
        return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
    }

    private boolean isNotDelimiter(char c) {
        return c < '\u0080' && !IS_DELIMITER[c];
    }

    private static char[] bytesToChars(byte[] json) throws JsonParseException {
        try {
            return StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(json)).array();
        }
        catch (CharacterCodingException e) {
            throw new JsonParseException(e);
        }
    }

    static {
        for (char c : ",:]}/\\\"[{;=#".toCharArray()) {
            JsonParser.IS_DELIMITER[c] = true;
        }
    }

    public static enum Option {
        KEEP_NULLS;

    }
}

