/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Token;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Status {
    public static final String FLOW_CONTROL_TEXT = "FlowControl Request";
    public static final String HEARTBEAT_TEXT = "Idle Heartbeat";
    public static final String NO_RESPONDERS_TEXT = "No Responders Available For Request";
    public static final String EOB_TEXT = "EOB";
    public static final byte[] FLOW_CONTROL_TEXT_BYTES = "FlowControl Request".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] HEARTBEAT_TEXT_BYTES = "Idle Heartbeat".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] NO_RESPONDERS_TEXT_BYTES = "No Responders Available For Request".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] EOB_TEXT_BYTES = "EOB".getBytes(StandardCharsets.ISO_8859_1);
    public static final int FLOW_OR_HEARTBEAT_STATUS_CODE = 100;
    public static final int NO_RESPONDERS_CODE = 503;
    public static final int BAD_REQUEST_CODE = 400;
    public static final int NOT_FOUND_CODE = 404;
    public static final int BAD_JS_REQUEST_CODE = 408;
    public static final int REQUEST_TIMEOUT_CODE = 408;
    public static final int CONFLICT_CODE = 409;
    public static final int EOB_CODE = 204;
    public static final int PIN_ERROR_CODE = 423;
    public static final byte[] PIN_ERROR_CODE_BYTES = "423".getBytes(StandardCharsets.ISO_8859_1);
    public static final String BAD_REQUEST = "Bad Request";
    public static final String NO_MESSAGES = "No Messages";
    public static final String CONSUMER_DELETED = "Consumer Deleted";
    public static final String CONSUMER_IS_PUSH_BASED = "Consumer is push based";
    public static final byte[] BAD_REQUEST_BYTES = "Bad Request".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] NO_MESSAGES_BYTES = "No Messages".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] CONSUMER_DELETED_BYTES = "Consumer Deleted".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] CONSUMER_IS_PUSH_BASED_BYTES = "Consumer is push based".getBytes(StandardCharsets.ISO_8859_1);
    public static final String MESSAGE_SIZE_EXCEEDS_MAX_BYTES = "Message Size Exceeds MaxBytes";
    public static final String EXCEEDED_MAX_PREFIX = "Exceeded Max";
    public static final String EXCEEDED_MAX_WAITING = "Exceeded MaxWaiting";
    public static final String EXCEEDED_MAX_REQUEST_BATCH = "Exceeded MaxRequestBatch";
    public static final String EXCEEDED_MAX_REQUEST_EXPIRES = "Exceeded MaxRequestExpires";
    public static final String EXCEEDED_MAX_REQUEST_MAX_BYTES = "Exceeded MaxRequestMaxBytes";
    public static final byte[] MESSAGE_SIZE_EXCEEDS_MAX_BYTES_BYTES = "Message Size Exceeds MaxBytes".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] EXCEEDED_MAX_WAITING_BYTES = "Exceeded MaxWaiting".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] EXCEEDED_MAX_REQUEST_BATCH_BYTES = "Exceeded MaxRequestBatch".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] EXCEEDED_MAX_REQUEST_EXPIRES_BYTES = "Exceeded MaxRequestExpires".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] EXCEEDED_MAX_REQUEST_MAX_BYTES_BYTES = "Exceeded MaxRequestMaxBytes".getBytes(StandardCharsets.ISO_8859_1);
    public static final String BATCH_COMPLETED = "Batch Completed";
    public static final String SERVER_SHUTDOWN = "Server Shutdown";
    public static final String LEADERSHIP_CHANGE = "Leadership Change";
    public static final byte[] BATCH_COMPLETED_BYTES = "Batch Completed".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] SERVER_SHUTDOWN_BYTES = "Server Shutdown".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] LEADERSHIP_CHANGE_BYTES = "Leadership Change".getBytes(StandardCharsets.ISO_8859_1);
    public static final Status EOB = new Status(204, "EOB");
    public static final Status TIMEOUT_OR_NO_MESSAGES = new Status(404, "Timeout or No Messages");
    private final int code;
    private final String message;
    private static final Map<Integer, String> CODE_TO_TEXT = new HashMap<Integer, String>();

    public Status(int code, String message) {
        this.code = code;
        this.message = message == null ? this.makeMessage(code) : message;
    }

    public Status(Token codeToken, Token messageToken) {
        this(Status.extractCode(codeToken), messageToken.getValueCheckKnownStatuses());
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageWithCode() {
        return this.code + " " + this.message;
    }

    private static int extractCode(Token codeToken) {
        try {
            String code = codeToken.getValueOrNull();
            if (code == null) {
                throw new IllegalArgumentException("Invalid header status code");
            }
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid header status code");
        }
    }

    private String makeMessage(int code) {
        String message = CODE_TO_TEXT.get(code);
        return message == null ? "Server Status Message: " + code : message;
    }

    public String toString() {
        return "Status{code=" + this.code + ", message='" + this.message + '\'' + '}';
    }

    public boolean isFlowControl() {
        return this.code == 100 && this.message.equals(FLOW_CONTROL_TEXT);
    }

    public boolean isHeartbeat() {
        return this.code == 100 && this.message.equals(HEARTBEAT_TEXT);
    }

    public boolean isNoResponders() {
        return this.code == 503 && this.message.equals(NO_RESPONDERS_TEXT);
    }

    public boolean isEob() {
        return this.code == 204 && this.message.equals(EOB_TEXT);
    }

    static {
        CODE_TO_TEXT.put(503, NO_RESPONDERS_TEXT);
    }
}

