/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.examples.chaosTestApp.support.CommandLine;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class Output
extends JPanel {
    static final ReentrantLock workLock;
    static final ReentrantLock controlLock;
    static final ReentrantLock debugLock;
    static boolean console;
    static boolean work;
    static boolean debug;
    static boolean started;
    static Output workInstance;
    static Output controlInstance;
    static Output debugInstance;
    static PrintStream workLog;
    static PrintStream controlLog;
    static PrintStream debugLog;
    static String controlConsoleAreaLabel;
    static final int HEIGHT_REDUCTION = 45;
    static final Font DISPLAY_FONT;
    static final int SCREEN_AVAILABLE_WIDTH;
    static final int SCREEN_AVAILABLE_HEIGHT;
    static final int ROWS;
    JTextArea area = new JTextArea(ROWS, 40);
    static final String NLINDENT = "\n    ";
    public static String FN;
    public static String FBN;

    public static void start(CommandLine cmd) {
        if (started) {
            return;
        }
        started = true;
        console = cmd.uiScreen == Screen.Console;
        work = cmd.work;
        debug = cmd.debug;
        if (console && (work || debug)) {
            controlConsoleAreaLabel = "CTRL";
        }
        if (cmd.logdir != null) {
            File f = new File(cmd.logdir);
            if (!f.exists() && !f.mkdirs()) {
                Output.errorMessage("OUTPUT", "Unable to create logdir: " + cmd.logdir);
                System.exit(-1);
            }
            String template = "applog-which.txt";
            try {
                String fn = template.replace("which", "control");
                Path p = Paths.get(f.getAbsolutePath(), fn);
                controlLog = new PrintStream(new FileOutputStream(p.toFile()));
                if (debug) {
                    fn = template.replace("which", "debug");
                    p = Paths.get(f.getAbsolutePath(), fn);
                    debugLog = new PrintStream(new FileOutputStream(p.toFile()));
                }
                if (work) {
                    fn = template.replace("which", "work");
                    p = Paths.get(f.getAbsolutePath(), fn);
                    workLog = new PrintStream(new FileOutputStream(p.toFile()));
                }
            }
            catch (FileNotFoundException e) {
                Output.errorMessage("OUTPUT", "Unable to create log file: " + e);
                System.exit(-1);
            }
        }
        int debugWidth = (int)((double)SCREEN_AVAILABLE_WIDTH * 0.42);
        int workWidth = (int)((double)SCREEN_AVAILABLE_WIDTH * 0.24);
        int controlWidth = SCREEN_AVAILABLE_WIDTH - debugWidth - workWidth;
        int offset = 0;
        if (cmd.uiScreen == Screen.Left) {
            if (debug || work) {
                if (debug) {
                    debugInstance = Output.newUi("Debug", -debugWidth, debugWidth, SCREEN_AVAILABLE_HEIGHT);
                    offset = -debugWidth;
                }
                if (work) {
                    controlInstance = Output.newUi("Control", offset -= controlWidth, controlWidth, SCREEN_AVAILABLE_HEIGHT);
                    workInstance = Output.newUi("Work", offset - workWidth, workWidth, SCREEN_AVAILABLE_HEIGHT);
                } else {
                    controlInstance = Output.newUi("Control", offset -= debugWidth, debugWidth, SCREEN_AVAILABLE_HEIGHT);
                }
            } else {
                offset = -SCREEN_AVAILABLE_WIDTH / 2;
                controlInstance = Output.newUi("Control", offset, -offset, SCREEN_AVAILABLE_HEIGHT);
            }
        } else if (cmd.uiScreen == Screen.Main) {
            if (debug || work) {
                if (debug) {
                    debugInstance = Output.newUi("Debug", 0, debugWidth, SCREEN_AVAILABLE_HEIGHT);
                    offset = debugWidth;
                }
                if (work) {
                    controlInstance = Output.newUi("Control", offset, controlWidth, SCREEN_AVAILABLE_HEIGHT);
                    workInstance = Output.newUi("Work", offset += controlWidth, workWidth, SCREEN_AVAILABLE_HEIGHT);
                } else {
                    controlInstance = Output.newUi("Control", offset, debugWidth, SCREEN_AVAILABLE_HEIGHT);
                }
            } else {
                offset = SCREEN_AVAILABLE_WIDTH / 2;
                controlInstance = Output.newUi("Control", 0, offset, SCREEN_AVAILABLE_HEIGHT);
            }
        }
    }

    private static Output newUi(String name, int xLoc, int width, int height) {
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(3);
        Output output = new Output();
        frame.add(output);
        frame.setLocation(xLoc, 0);
        frame.setPreferredSize(new Dimension(width, height));
        frame.pack();
        frame.setVisible(true);
        return output;
    }

    private Output() {
        super(new GridLayout(1, 1));
        this.area.setEditable(false);
        this.area.setFont(DISPLAY_FONT);
        this.add(new JScrollPane(this.area));
    }

    private static String time() {
        String t = "" + System.currentTimeMillis();
        return t.substring(t.length() - 9);
    }

    public static void workMessage(String label, String s) {
        if (work) {
            workLock.lock();
            try {
                if (console) {
                    Output.consoleMessage("WORK", label, s);
                } else {
                    Output.append(label, s, Output.workInstance.area);
                }
                if (workLog != null) {
                    Output.consoleMessage(null, label, s, workLog);
                }
            }
            finally {
                workLock.unlock();
            }
        }
    }

    public static void controlMessage(String label, JsonSerializable j) {
        Output.controlMessage(label, Output.formatted(j));
    }

    public static void controlMessage(String label, String jvLabel, JsonValue jv) {
        Output.controlMessage(label, Output.formatted(jv).replace("JsonValue", jvLabel));
    }

    public static void controlMessage(String label, String s) {
        controlLock.lock();
        try {
            if (console) {
                Output.consoleMessage(controlConsoleAreaLabel, label, s);
            } else {
                Output.append(label, s, Output.controlInstance.area);
            }
            if (workLog != null) {
                Output.consoleMessage(null, label, s, controlLog);
            }
        }
        finally {
            controlLock.unlock();
        }
    }

    public static void dumpControl() {
        Output.dump("Control", Output.controlInstance.area.getDocument());
    }

    private static void dump(String label, Document document) {
        try {
            System.out.println("----------------------------------------------------------------------------------------------------");
            System.out.println("UI-" + label);
            System.out.println("----------------------------------------------------------------------------------------------------");
            System.out.println(document.getText(0, document.getLength()));
            System.out.println("----------------------------------------------------------------------------------------------------");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void debugMessage(String label, String s) {
        if (debug) {
            debugLock.lock();
            try {
                if (console) {
                    Output.consoleMessage("DEBUG", label, s);
                } else {
                    Output.debugInstance.area.append(s);
                    Output.debugInstance.area.append("\n");
                    Output.afterAppend(Output.debugInstance.area);
                }
                if (debugLog != null) {
                    Output.consoleMessage("DEBUG", label, s + "\n", controlLog);
                }
            }
            finally {
                debugLock.unlock();
            }
        }
    }

    private static void append(String label, String s, JTextArea area) {
        if (s.contains("\n")) {
            String timeLabel = Output.time() + " | " + label;
            area.append(timeLabel);
            if (!s.startsWith("\n")) {
                area.append(" | ");
            }
            area.append(s.replace("\n", NLINDENT));
        } else {
            area.append(Output.time());
            area.append(" | ");
            area.append(label);
            area.append(" | ");
            area.append(s);
        }
        area.append("\n");
        Output.afterAppend(area);
    }

    public static void errorMessage(String label, String s) {
        Output.consoleMessage("ERROR", label, s, System.out);
    }

    public static void fatalMessage(String label, String s) {
        Output.consoleMessage("FATAL", label, s, System.out);
    }

    public static void consoleMessage(String area, String label, String s) {
        Output.consoleMessage(area, label, s, System.out);
    }

    public static void consoleMessage(String area, String label, String s, PrintStream out) {
        out.print(Output.time());
        String llabel = label == null ? "" : " | " + label;
        out.print(area == null ? llabel : " | " + area + llabel);
        if (s.contains("\n")) {
            if (!s.startsWith("\n")) {
                out.print(" | ");
            }
            out.print(s.replace("\n", NLINDENT));
        } else {
            out.print(" | ");
            out.print(s);
        }
        out.println();
    }

    private static void afterAppend(JTextArea area) {
        int c = area.getLineCount();
        while (c > ROWS) {
            try {
                int end = area.getLineEndOffset(1);
                area.getDocument().remove(0, end);
                c = area.getLineCount();
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String formatted(JsonSerializable j) {
        return j.getClass().getSimpleName() + j.toJson().replace("{\"", FBN + "\"").replace(",", "," + FN);
    }

    public static String formatted(Object o) {
        return Output.formatted(o.toString());
    }

    public static String formatted(String s) {
        return s.replace("{", FBN).replace(", ", "," + FN);
    }

    static {
        String[] allfonts;
        workLock = new ReentrantLock();
        controlLock = new ReentrantLock();
        debugLock = new ReentrantLock();
        controlConsoleAreaLabel = null;
        String fontName = "Monospaced";
        GraphicsEnvironment localEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String allfont : allfonts = localEnv.getAvailableFontFamilyNames()) {
            if (!allfont.equals("JetBrains Mono")) continue;
            fontName = allfont;
            break;
        }
        DISPLAY_FONT = new Font(fontName, 0, 14);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        SCREEN_AVAILABLE_WIDTH = (int)screenSize.getWidth();
        SCREEN_AVAILABLE_HEIGHT = (int)screenSize.getHeight() - 45;
        ROWS = SCREEN_AVAILABLE_HEIGHT / 21;
        FN = "\n  ";
        FBN = "{\n  ";
    }

    public static enum Screen {
        Left,
        Main,
        Console;

    }
}

