/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.PublishAck;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.OutputErrorListener;
import io.nats.examples.chaosTestApp.support.CommandLine;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class Publisher
implements Runnable {
    static final String LABEL = "PUBLISHER";
    final CommandLine cmd;
    final long pubDelay;
    final AtomicLong lastSeqno = new AtomicLong(-1L);
    final AtomicLong errorRun = new AtomicLong(0L);

    public Publisher(CommandLine cmd, long pubDelay) {
        this.cmd = cmd;
        this.pubDelay = pubDelay;
    }

    public long getLastSeqno() {
        return this.lastSeqno.get();
    }

    public boolean isInErrorState() {
        return this.errorRun.get() > 0L;
    }

    @Override
    public void run() {
        Options options = new Options.Builder().servers(this.cmd.servers).connectionListener((c, t) -> Output.controlMessage(LABEL, "Connection: " + c.getServerInfo().getPort() + " " + (Object)((Object)t))).errorListener(new OutputErrorListener(LABEL){}).maxReconnects(-1).build();
        try {
            Connection nc = Nats.connect(options);
            Throwable throwable = null;
            try {
                try {
                    JetStream js = nc.jetStream();
                    while (true) {
                        block18: {
                            if (this.lastSeqno.get() == -1L) {
                                Output.controlMessage(LABEL, "Starting Publish");
                                this.lastSeqno.set(0L);
                            }
                            try {
                                PublishAck pa = js.publish(this.cmd.subject, null);
                                this.lastSeqno.set(pa.getSeqno());
                                if (this.errorRun.get() > 0L) {
                                    Output.controlMessage(LABEL, "Restarting Publish");
                                }
                                this.errorRun.set(0L);
                            }
                            catch (Exception e) {
                                if (this.errorRun.incrementAndGet() != 1L) break block18;
                                Output.controlMessage(LABEL, e.getMessage());
                            }
                        }
                        try {
                            Thread.sleep(ThreadLocalRandom.current().nextLong(this.pubDelay));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (nc != null) {
                    if (throwable != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        nc.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }
}

