/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.ConsumerContext;
import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.StreamContext;
import io.nats.examples.chaosTestApp.ConnectableConsumer;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.support.CommandLine;
import io.nats.examples.chaosTestApp.support.ConsumerKind;
import java.io.IOException;

public class SimpleFetchConsumer
extends ConnectableConsumer
implements Runnable {
    final StreamContext sc;
    final ConsumerContext cc;
    final int batchSize;
    final long expiresIn;
    final Thread t;
    FetchConsumer fc;

    public SimpleFetchConsumer(CommandLine cmd, ConsumerKind consumerKind, int batchSize, long expiresIn) throws IOException, InterruptedException, JetStreamApiException {
        super(cmd, "fc", consumerKind);
        if (consumerKind == ConsumerKind.Ordered) {
            throw new IllegalArgumentException("Ordered Consumer not supported for App Simple Fetch");
        }
        this.batchSize = batchSize;
        this.expiresIn = expiresIn;
        this.sc = this.nc.getStreamContext(cmd.stream);
        this.cc = this.sc.createOrUpdateConsumer(this.newCreateConsumer().build());
        Output.controlMessage(this.label, this.cc.getConsumerName());
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void run() {
        FetchConsumeOptions fco = FetchConsumeOptions.builder().maxMessages(this.batchSize).expiresIn(this.expiresIn).build();
        Output.controlMessage(this.label, SimpleFetchConsumer.toString(fco));
        while (true) {
            try (FetchConsumer autoCloseableFc2 = this.cc.fetch(fco);){
                this.fc = autoCloseableFc2;
                Message m = this.fc.nextMessage();
                while (m != null) {
                    this.onMessage(m);
                    m = this.fc.nextMessage();
                }
            }
            catch (Exception autoCloseableFc2) {
                // empty catch block
            }
            try {
                Output.workMessage(this.label, "Fetch Batch Completed, Last Received Seq: " + this.lastReceivedSequence.get());
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void refreshInfo() {
        if (this.fc != null) {
            this.updateLabel(this.fc.getConsumerName());
        }
    }

    public static String toString(FetchConsumeOptions fco) {
        return "FetchConsumeOptions\nMax Messages: " + fco.getMaxMessages() + "\nMax Bytes: " + fco.getMaxBytes() + "\nExpires In: " + fco.getExpiresInMillis() + "\nIdleHeartbeat: " + fco.getIdleHeartbeat() + "\nThreshold Percent: " + fco.getThresholdPercent();
    }
}

