/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream.simple;

import io.nats.client.Connection;
import io.nats.client.ConsumerContext;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;

public class ContextExample {
    private static final String STREAM = "context-stream";
    private static final String SUBJECT = "context-subject";
    private static final String CONSUMER_NAME = "context-consumer";
    public static String SERVER = "nats://localhost:4222";

    public static void main(String[] args) {
        Options options = Options.builder().server(SERVER).build();
        try (Connection nc = Nats.connect(options);){
            JetStream js = nc.jetStream();
            NatsJsUtils.createOrReplaceStream(nc.jetStreamManagement(), STREAM, SUBJECT);
            StreamContext streamContext = nc.getStreamContext(STREAM);
            System.out.println("S1. " + streamContext.getStreamInfo());
            streamContext = nc.getStreamContext(STREAM, JetStreamOptions.builder().build());
            System.out.println("S2. " + streamContext.getStreamInfo());
            streamContext = js.getStreamContext(STREAM);
            System.out.println("S3. " + streamContext.getStreamInfo());
            ConsumerContext consumerContext = streamContext.createOrUpdateConsumer(ConsumerConfiguration.builder().durable(CONSUMER_NAME).build());
            System.out.println("C1. " + consumerContext.getCachedConsumerInfo());
            consumerContext = nc.getConsumerContext(STREAM, CONSUMER_NAME);
            System.out.println("C2. " + consumerContext.getCachedConsumerInfo());
            consumerContext = nc.getConsumerContext(STREAM, CONSUMER_NAME, JetStreamOptions.builder().build());
            System.out.println("C3. " + consumerContext.getCachedConsumerInfo());
            consumerContext = streamContext.getConsumerContext(CONSUMER_NAME);
            System.out.println("C4. " + consumerContext.getCachedConsumerInfo());
        }
        catch (JetStreamApiException | IOException | InterruptedException exception) {
            // empty catch block
        }
    }
}

