/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream.simple;

import io.nats.client.Connection;
import io.nats.client.ConsumerContext;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;

public class NextExample {
    private static final String STREAM = "next-stream";
    private static final String SUBJECT = "next-subject";
    private static final String CONSUMER_NAME = "next-consumer";
    public static String SERVER = "nats://localhost:4222";

    public static void main(String[] args) {
        Options options = Options.builder().server(SERVER).build();
        try (Connection nc = Nats.connect(options);){
            ConsumerContext consumerContext;
            JetStream js = nc.jetStream();
            NatsJsUtils.createOrReplaceStream(nc.jetStreamManagement(), STREAM, SUBJECT);
            try {
                StreamContext streamContext = nc.getStreamContext(STREAM);
                consumerContext = streamContext.createOrUpdateConsumer(ConsumerConfiguration.builder().durable(CONSUMER_NAME).build());
            }
            catch (JetStreamApiException | IOException e) {
                if (nc != null) {
                    if (var3_4 != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        nc.close();
                    }
                }
                return;
            }
            int count = 20;
            Thread t = new Thread(() -> {
                int sleep = 2000;
                boolean down = true;
                for (int x = 1; x <= count; ++x) {
                    try {
                        Thread.sleep(sleep);
                        if (down) {
                            down = (sleep -= 200) > 0;
                        } else {
                            sleep += 200;
                        }
                        js.publish(SUBJECT, ("message-" + x).getBytes());
                        continue;
                    }
                    catch (JetStreamApiException | IOException | InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            t.start();
            int received = 0;
            while (received < count) {
                try {
                    long start = System.currentTimeMillis();
                    Message m = consumerContext.next(1000L);
                    long elapsed = System.currentTimeMillis() - start;
                    if (m == null) {
                        System.out.println("Waited " + elapsed + "ms for message, got null");
                        continue;
                    }
                    ++received;
                    m.ack();
                    System.out.println("Waited " + elapsed + "ms for message, got " + new String(m.getData()));
                }
                catch (JetStreamApiException | JetStreamStatusCheckedException | IOException | InterruptedException e) {
                    if (nc != null) {
                        if (var3_4 != null) {
                            try {
                                nc.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            nc.close();
                        }
                    }
                    return;
                }
            }
            t.join();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }
}

