/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.stability;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.Subscription;
import io.nats.examples.benchmark.Utils;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;

public class StabilitySub {
    static final String usageString = "\nUsage: java -cp <classpath> StabilitySub [server] <subject>\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n";

    public static void main(String[] args) {
        String subject;
        String server;
        long nullCount = 0L;
        long messageCount = 0L;
        long payloadCount = 0L;
        long restarts = 0L;
        if (args.length == 2) {
            server = args[0];
            subject = args[1];
        } else if (args.length == 1) {
            server = "nats://localhost:4222";
            subject = args[0];
        } else {
            StabilitySub.usage();
            return;
        }
        Instant start = Instant.now();
        System.out.println("Running stability subscriber for indefinite test, ctrl-c to cancel...\n");
        while (true) {
            try {
                while (true) {
                    Options options = new Options.Builder().server(server).noReconnect().build();
                    Connection nc = Nats.connect(options);
                    Subscription sub = nc.subscribe(subject);
                    try {
                        while (true) {
                            Message msg;
                            if ((msg = sub.nextMessage(Duration.ofHours(1L))) == null) {
                                ++nullCount;
                            } else if (msg.getData() != null) {
                                payloadCount += (long)msg.getData().length;
                            }
                            if (++messageCount == 0L || messageCount % 100000L != 0L) continue;
                            Instant finish = Instant.now();
                            System.out.printf("Running for %s\n", Duration.between(start, finish).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase());
                            System.out.printf("Received %s messages.\n", NumberFormat.getIntegerInstance().format(messageCount));
                            System.out.printf("Received %s payload bytes.\n", Utils.humanBytes(payloadCount));
                            System.out.printf("Received %s null messages.\n", NumberFormat.getIntegerInstance().format(nullCount));
                            System.out.printf("Restarted %s times.\n", NumberFormat.getIntegerInstance().format(restarts));
                            System.out.printf("Current memory usage is %s / %s / %s free/total/max\n", Utils.humanBytes(Runtime.getRuntime().freeMemory()), Utils.humanBytes(Runtime.getRuntime().totalMemory()), Utils.humanBytes(Runtime.getRuntime().maxMemory()));
                            System.out.println();
                        }
                    }
                    catch (Exception exp) {
                        System.out.println("Exception from running connection, creating a new one.");
                        exp.printStackTrace();
                        System.out.println("Reconnecting...");
                        System.out.println();
                        ++restarts;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                System.out.println("Exception connecting, exiting...");
                exp.printStackTrace();
                System.exit(-1);
                continue;
            }
            break;
        }
    }

    static void usage() {
        System.err.println(usageString);
        System.exit(-1);
    }
}

