/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.JsonSerializable;
import java.nio.charset.StandardCharsets;

public class ServiceMessage {
    public static final String NATS_SERVICE_ERROR = "Nats-Service-Error";
    public static final String NATS_SERVICE_ERROR_CODE = "Nats-Service-Error-Code";
    private final Message message;

    ServiceMessage(Message message) {
        this.message = message;
    }

    public void respond(Connection conn, byte[] response) {
        conn.publish(this.message.getReplyTo(), response);
    }

    public void respond(Connection conn, String response) {
        conn.publish(this.message.getReplyTo(), response.getBytes(StandardCharsets.UTF_8));
    }

    public void respond(Connection conn, JsonSerializable response) {
        conn.publish(this.message.getReplyTo(), response.serialize());
    }

    public void respond(Connection conn, byte[] response, Headers headers) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).data(response).headers(headers).build());
    }

    public void respond(Connection conn, String response, Headers headers) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).data(response).headers(headers).build());
    }

    public void respond(Connection conn, JsonSerializable response, Headers headers) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).data(response.serialize()).headers(headers).build());
    }

    public void respondStandardError(Connection conn, String errorText, int errorCode) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).headers(new Headers().put(NATS_SERVICE_ERROR, errorText).put(NATS_SERVICE_ERROR_CODE, "" + errorCode)).build());
    }

    public String getSubject() {
        return this.message.getSubject();
    }

    public String getReplyTo() {
        return this.message.getReplyTo();
    }

    public boolean hasHeaders() {
        return this.message.hasHeaders();
    }

    public Headers getHeaders() {
        return this.message.getHeaders();
    }

    public byte[] getData() {
        return this.message.getData();
    }
}

