/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.MirrorInfo;
import io.nats.client.api.SourceInfo;
import io.nats.client.api.StreamAlternate;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamState;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class StreamInfo
extends ApiResponse<StreamInfo> {
    private final ZonedDateTime createTime;
    private final StreamConfiguration config;
    private final StreamState streamState;
    private final ClusterInfo clusterInfo;
    private final MirrorInfo mirrorInfo;
    private final List<SourceInfo> sourceInfos;
    private final List<StreamAlternate> alternates;
    private final ZonedDateTime timestamp;

    public StreamInfo(@NonNull Message msg) {
        this(JsonParser.parseUnchecked(msg.getData()));
    }

    public StreamInfo(@NonNull JsonValue vStreamInfo) {
        super(vStreamInfo);
        if (this.hasError()) {
            this.createTime = DateTimeUtils.DEFAULT_TIME;
            this.config = StreamConfiguration.builder().name("UNDEFINED").build();
            this.streamState = new StreamState(JsonValue.EMPTY_MAP);
            this.clusterInfo = null;
            this.mirrorInfo = null;
            this.sourceInfos = null;
            this.alternates = null;
            this.timestamp = null;
        } else {
            JsonValue jvConfig = this.nullValueIsError(this.jv, "config", JsonValue.NULL);
            this.config = jvConfig == JsonValue.NULL ? StreamConfiguration.builder().name("UNDEFINED").build() : StreamConfiguration.instance(jvConfig);
            this.createTime = this.nullDateIsError(this.jv, "created");
            this.streamState = new StreamState(JsonValueUtils.readValue(this.jv, "state"));
            this.clusterInfo = ClusterInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "cluster"));
            this.mirrorInfo = MirrorInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "mirror"));
            this.sourceInfos = SourceInfo.optionalListOf(JsonValueUtils.readValue(this.jv, "sources"));
            this.alternates = StreamAlternate.optionalListOf(JsonValueUtils.readValue(this.jv, "alternates"));
            this.timestamp = JsonValueUtils.readDate(this.jv, "ts");
        }
    }

    public @NonNull StreamConfiguration getConfiguration() {
        return this.config;
    }

    public @NonNull StreamConfiguration getConfig() {
        return this.config;
    }

    public @NonNull StreamState getStreamState() {
        return this.streamState;
    }

    public @NonNull ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    public @Nullable MirrorInfo getMirrorInfo() {
        return this.mirrorInfo;
    }

    public @Nullable List<SourceInfo> getSourceInfos() {
        return this.sourceInfos;
    }

    public @Nullable ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public @Nullable List<StreamAlternate> getAlternates() {
        return this.alternates;
    }

    public @Nullable ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String toString() {
        return "StreamInfo " + this.jv;
    }
}

