/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.NatsJetStreamConstants;
import io.nats.client.support.Status;
import io.nats.client.support.TokenType;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Token {
    private final byte[] serialized;
    private final TokenType type;
    private final int start;
    private int end;
    private boolean hasValue;
    private final int valueLength;
    static final byte[] NATS_DASH_PREFIX_BYTES = "Nats-".getBytes();
    static final byte[] EXCEEDED_MAX_PREFIX_BYTES = "Exceeded Max".getBytes();
    static final int EXCEEDED_MAX_PREFIX_BYTES_LEN = "Exceeded Max".length();

    public Token(byte[] serialized, int len, Token prev, TokenType required) {
        this(serialized, len, prev.end + (prev.type == TokenType.KEY ? 2 : 1), required);
    }

    public Token(byte[] serialized, int len, int cur, TokenType required) {
        this.serialized = serialized;
        if (cur >= len) {
            throw new IllegalArgumentException("Invalid header composition");
        }
        if (serialized[cur] == 32) {
            this.type = TokenType.SPACE;
            this.start = cur;
            this.end = cur;
            while (serialized[++cur] == 32) {
                this.end = cur;
            }
        } else if (serialized[cur] == 13) {
            this.mustBeCrlf(len, cur);
            this.type = TokenType.CRLF;
            this.start = cur;
            this.end = cur + 1;
        } else {
            byte ender2;
            byte ender1;
            if (required == TokenType.CRLF || required == TokenType.SPACE) {
                throw new IllegalArgumentException("Invalid header composition");
            }
            if (required == null || required == TokenType.TEXT) {
                this.type = TokenType.TEXT;
                ender1 = 13;
                ender2 = 13;
            } else if (required == TokenType.WORD) {
                ender1 = 32;
                ender2 = 13;
                this.type = TokenType.WORD;
            } else {
                ender1 = 58;
                ender2 = 58;
                this.type = TokenType.KEY;
            }
            this.start = cur;
            this.end = cur;
            while (++cur < len && serialized[cur] != ender1 && serialized[cur] != ender2) {
                this.end = cur;
            }
            if (cur >= len) {
                throw new IllegalArgumentException("Invalid header composition");
            }
            if (serialized[cur] == 13) {
                this.mustBeCrlf(len, cur);
            }
            this.hasValue = true;
        }
        this.valueLength = this.hasValue ? this.end - this.start + 1 : 0;
    }

    private void mustBeCrlf(int len, int cur) {
        if (cur + 1 >= len || this.serialized[cur + 1] != 10) {
            throw new IllegalArgumentException("Invalid header composition");
        }
    }

    public void mustBe(TokenType expected) {
        if (this.type != expected) {
            throw new IllegalArgumentException("Invalid header composition");
        }
    }

    public boolean isType(TokenType expected) {
        return this.type == expected;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public @NonNull String getValue() {
        return this.hasValue ? this.valueAsString() : "";
    }

    public @Nullable String getValueOrNull() {
        return this.hasValue ? this.valueAsString() : null;
    }

    private String valueAsString() {
        return new String(this.serialized, this.start, this.valueLength, StandardCharsets.UTF_8).trim();
    }

    public @NonNull String getValueCheckKnownKeys() {
        if (this.valueLength == 0) {
            return "";
        }
        if (this.valueLength > 5) {
            if (this.valueStartsNatsDash()) {
                if (this.endsMatch(NatsJetStreamConstants.NATS_STREAM_BYTES, 5)) {
                    return "Nats-Stream";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_SEQUENCE_BYTES, 5)) {
                    return "Nats-Sequence";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_TIMESTAMP_BYTES, 5)) {
                    return "Nats-Time-Stamp";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_SUBJECT_BYTES, 5)) {
                    return "Nats-Subject";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_LAST_SEQUENCE_BYTES, 5)) {
                    return "Nats-Last-Sequence";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_NUM_PENDING_BYTES, 5)) {
                    return "Nats-Num-Pending";
                }
                if (this.endsMatch(NatsJetStreamConstants.CONSUMER_STALLED_HDR_BYTES, 5)) {
                    return "Nats-Consumer-Stalled";
                }
                if (this.endsMatch(NatsJetStreamConstants.MSG_SIZE_HDR_BYTES, 5)) {
                    return "Nats-Msg-Size";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_MARKER_REASON_HDR_BYTES, 5)) {
                    return "Nats-Marker-Reason";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_PENDING_MESSAGES_BYTES, 5)) {
                    return "Nats-Pending-Messages";
                }
                if (this.endsMatch(NatsJetStreamConstants.NATS_PENDING_BYTES_BYTES, 5)) {
                    return "Nats-Pending-Bytes";
                }
            } else if (this.endsMatch(NatsJetStreamConstants.KV_OPERATION_HEADER_KEY_BYTES, 0)) {
                return "KV-Operation";
            }
        }
        return this.valueAsString();
    }

    public @Nullable String getValueCheckKnownStatuses() {
        if (this.valueLength == 0) {
            return null;
        }
        if (this.valueLength > 10) {
            switch (this.serialized[this.start]) {
                case 69: {
                    if (!this.valueStartsWithExceededMax()) break;
                    if (this.endsMatch(Status.EXCEEDED_MAX_WAITING_BYTES, 8)) {
                        return "Exceeded MaxWaiting";
                    }
                    if (this.endsMatch(Status.EXCEEDED_MAX_REQUEST_BATCH_BYTES, 8)) {
                        return "Exceeded MaxRequestBatch";
                    }
                    if (this.endsMatch(Status.EXCEEDED_MAX_REQUEST_EXPIRES_BYTES, 8)) {
                        return "Exceeded MaxRequestExpires";
                    }
                    if (!this.endsMatch(Status.EXCEEDED_MAX_REQUEST_MAX_BYTES_BYTES, 8)) break;
                    return "Exceeded MaxRequestMaxBytes";
                }
                case 66: {
                    if (this.endsMatch(Status.BATCH_COMPLETED_BYTES, 1)) {
                        return "Batch Completed";
                    }
                    if (!this.endsMatch(Status.BAD_REQUEST_BYTES, 1)) break;
                    return "Bad Request";
                }
                case 78: {
                    if (this.endsMatch(Status.NO_RESPONDERS_TEXT_BYTES, 1)) {
                        return "No Responders Available For Request";
                    }
                    if (!this.endsMatch(Status.NO_MESSAGES_BYTES, 1)) break;
                    return "No Messages";
                }
                case 70: {
                    if (!this.endsMatch(Status.FLOW_CONTROL_TEXT_BYTES, 1)) break;
                    return "FlowControl Request";
                }
                case 73: {
                    if (!this.endsMatch(Status.HEARTBEAT_TEXT_BYTES, 1)) break;
                    return "Idle Heartbeat";
                }
                case 77: {
                    if (!this.endsMatch(Status.MESSAGE_SIZE_EXCEEDS_MAX_BYTES_BYTES, 1)) break;
                    return "Message Size Exceeds MaxBytes";
                }
                case 76: {
                    if (!this.endsMatch(Status.LEADERSHIP_CHANGE_BYTES, 1)) break;
                    return "Leadership Change";
                }
                case 83: {
                    if (!this.endsMatch(Status.SERVER_SHUTDOWN_BYTES, 1)) break;
                    return "Server Shutdown";
                }
                case 67: {
                    if (this.endsMatch(Status.CONSUMER_DELETED_BYTES, 1)) {
                        return "Consumer Deleted";
                    }
                    if (!this.endsMatch(Status.CONSUMER_IS_PUSH_BASED_BYTES, 1)) break;
                    return "Consumer is push based";
                }
            }
        } else if (this.endsMatch(Status.EOB_TEXT_BYTES, 0)) {
            return "EOB";
        }
        return this.valueAsString();
    }

    private boolean valueStartsNatsDash() {
        for (int i = 0; i < 4; ++i) {
            if (NATS_DASH_PREFIX_BYTES[i] == this.serialized[this.start + i]) continue;
            return false;
        }
        return true;
    }

    private boolean valueStartsWithExceededMax() {
        for (int i = 1; i < EXCEEDED_MAX_PREFIX_BYTES_LEN; ++i) {
            if (EXCEEDED_MAX_PREFIX_BYTES[i] == this.serialized[this.start + i]) continue;
            return false;
        }
        return true;
    }

    private boolean endsMatch(byte @NonNull [] checkBytes, int compareStartIndex) {
        if (this.valueLength != checkBytes.length) {
            return false;
        }
        for (int i = compareStartIndex; i < this.valueLength; ++i) {
            if (checkBytes[i] == this.serialized[this.start + i]) continue;
            return false;
        }
        return true;
    }

    public boolean samePoint(Token token) {
        return this.start == token.start && this.end == token.end && this.type == token.type;
    }
}

