/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.examples.autobench.AutoBenchmark;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class JsPubAsyncRoundsBenchmark
extends AutoBenchmark {
    private final boolean file;
    private final long roundSize;

    public JsPubAsyncRoundsBenchmark(String name, long messageCount, long messageSize, boolean file, long roundSize) {
        super(name, messageCount, messageSize);
        this.file = file;
        this.roundSize = roundSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Options connectOptions) throws InterruptedException {
        byte[] payload = this.createPayload();
        String subject = this.getSubject();
        String stream = this.getStream();
        try {
            Connection nc = Nats.connect(connectOptions);
            StreamConfiguration sc = StreamConfiguration.builder().name(stream).subjects(subject).storageType(this.file ? StorageType.File : StorageType.Memory).build();
            JetStreamManagement jsm = nc.jetStreamManagement();
            jsm.addStream(sc);
            JetStream js = nc.jetStream();
            try {
                long messagesLeft = this.getMessageCount();
                this.startTiming();
                while (messagesLeft > 0L) {
                    long thisRound;
                    if (messagesLeft > this.roundSize) {
                        thisRound = this.roundSize;
                        messagesLeft -= this.roundSize;
                    } else {
                        thisRound = messagesLeft;
                        messagesLeft = 0L;
                    }
                    ArrayList<CompletableFuture<PublishAck>> futures = new ArrayList<CompletableFuture<PublishAck>>((int)this.roundSize);
                    for (long l = 0L; l < thisRound; ++l) {
                        futures.add(js.publishAsync(subject, payload));
                    }
                    while (futures.size() > 0) {
                        ArrayList<CompletableFuture> notDone = new ArrayList<CompletableFuture>((int)this.roundSize);
                        for (CompletableFuture completableFuture : futures) {
                            if (completableFuture.isDone()) continue;
                            notDone.add(completableFuture);
                        }
                        futures = notDone;
                    }
                }
                this.defaultFlush(nc);
                this.endTiming();
            }
            finally {
                try {
                    jsm.deleteStream(stream);
                }
                catch (JetStreamApiException | IOException ex) {
                    this.setException(ex);
                }
                finally {
                    nc.close();
                }
            }
        }
        catch (JetStreamApiException | IOException ex) {
            this.setException(ex);
        }
    }
}

