/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.NUID;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsMessage;
import io.nats.examples.autobench.AutoBenchmark;
import java.io.IOException;

public class PubWithHeadersBenchmark
extends AutoBenchmark {
    public PubWithHeadersBenchmark(String name, long messageCount, long messageSize) {
        super(name, messageCount, messageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Options connectOptions) throws InterruptedException {
        int msize = (int)this.getMessageSize();
        int headersSize = msize / 10;
        if (headersSize < 4) {
            headersSize = 4;
        }
        msize = Math.max(0, msize - headersSize);
        byte[] payload = new byte[msize];
        StringBuilder sb = new StringBuilder();
        while (sb.length() < headersSize) {
            sb.append(NUID.nextGlobal());
        }
        String headerValue = sb.substring(0, headersSize - 3);
        String subject = this.getSubject();
        try (Connection nc = Nats.connect(connectOptions);){
            this.startTiming();
            int i = 0;
            while ((long)i < this.getMessageCount()) {
                nc.publish(NatsMessage.builder().subject(subject).data(payload).headers(new Headers().put("hdr", headerValue)).build());
                ++i;
            }
            this.defaultFlush(nc);
            this.endTiming();
        }
        catch (IOException ex) {
            this.setException(ex);
        }
    }
}

