/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.benchmark;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.impl.NatsMessage;
import io.nats.examples.ExampleUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class JsPublishInRoundsBench {
    static final String usageString = "\nUsage: java JsPublishInRoundsBench [serverURL] [help] [-m totalMessages] [-p payloadSize] [-r roundSize] [-o file|memory] [-c replicas] [-t stream] [-u subject]\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext";

    public static void main(String[] args) {
        Arguments a = JsPublishInRoundsBench.readArgs(args);
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(a.server, true));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            StreamConfiguration.Builder builder = StreamConfiguration.builder().name(a.stream).storageType(a.file ? StorageType.File : StorageType.Memory).subjects(a.subject);
            if (a.replicas > 0) {
                builder.replicas(a.replicas);
            }
            StreamConfiguration sc = builder.build();
            try {
                jsm.addStream(sc);
                nc.flush(Duration.ofSeconds(5L));
            }
            catch (Exception e) {
                System.out.println(e);
            }
            JetStream js = nc.jetStream();
            NatsMessage m = NatsMessage.builder().subject(a.subject).data(new byte[a.payloadSize]).build();
            int sent = 0;
            int failed = 0;
            long totalElapsed = 0L;
            while (sent + failed < a.totalMsgs) {
                long start = System.currentTimeMillis();
                ArrayList<CompletableFuture<PublishAck>> futures = new ArrayList<CompletableFuture<PublishAck>>();
                for (int x = 0; x < a.roundSize; ++x) {
                    futures.add(js.publishAsync(m));
                }
                while (futures.size() > 0) {
                    ArrayList<CompletableFuture> notDone = new ArrayList<CompletableFuture>();
                    for (CompletableFuture completableFuture : futures) {
                        if (completableFuture.isDone()) {
                            if (completableFuture.isCompletedExceptionally()) {
                                ++failed;
                                continue;
                            }
                            ++sent;
                            continue;
                        }
                        notDone.add(completableFuture);
                    }
                    futures = notDone;
                }
                long roundElapsed = System.currentTimeMillis() - start;
                totalElapsed += roundElapsed;
                if ((sent + failed) % 10000 != 0) continue;
                long l = totalElapsed == 0L ? 0L : (long)(sent + failed) * 1000L / totalElapsed;
                System.out.println("Sent " + sent + " | Failed " + failed + " | " + (sent + failed) + " | Round Elapsed " + roundElapsed + " | Total Elapsed " + totalElapsed + " | Pub/Sec " + l);
            }
            long pubPerSec = (long)(sent + failed) * 1000L / totalElapsed;
            System.out.println("\nFINAL Sent " + sent + " | Failed " + failed + " | " + (sent + failed) + " | Total Elapsed " + totalElapsed + " | Pub/Sec " + pubPerSec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String defaultArgs() {
        Arguments a = new Arguments();
        return "\n\nDefault Arguments: server='" + a.server + '\'' + ", totalMsgs=" + a.totalMsgs + ", payloadSize=" + a.payloadSize + ", roundSize=" + a.roundSize + ", replicas=" + a.replicas + ", storage=" + (Object)((Object)StorageType.Memory) + ", stream='jspirb-strm-<unique>" + '\'' + ", subject='jspirb-sub-<unique>" + '\'';
    }

    private static Arguments readArgs(String[] args) {
        Arguments a = new Arguments();
        if (args.length > 0) {
            block20: for (int x = 0; x < args.length; ++x) {
                switch (args[x]) {
                    case "-m": {
                        a.totalMsgs = Integer.parseInt(args[++x]);
                        continue block20;
                    }
                    case "-p": {
                        a.payloadSize = Integer.parseInt(args[++x]);
                        continue block20;
                    }
                    case "-r": {
                        a.roundSize = Integer.parseInt(args[++x]);
                        continue block20;
                    }
                    case "-c": {
                        a.replicas = Integer.parseInt(args[++x]);
                        continue block20;
                    }
                    case "-o": {
                        a.file = args[++x].equalsIgnoreCase("file");
                        continue block20;
                    }
                    case "-t": {
                        a.stream = args[++x];
                        continue block20;
                    }
                    case "-u": {
                        a.subject = args[++x];
                        continue block20;
                    }
                    case "help": {
                        System.err.println(usageString + JsPublishInRoundsBench.defaultArgs());
                        System.exit(-1);
                    }
                    default: {
                        a.server = args[x];
                    }
                }
            }
        }
        return a;
    }

    static class Arguments {
        String server = "nats://localhost:4222";
        int totalMsgs = 1000000;
        int payloadSize = 128;
        int roundSize = 100;
        int replicas = 0;
        boolean file = false;
        String stream = "jspirb-strm-" + ExampleUtils.uniqueEnough();
        String subject = "jspirb-sub-" + ExampleUtils.uniqueEnough();

        Arguments() {
        }
    }
}

