/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp.support;

import io.nats.examples.chaosTestApp.support.ConsumerKind;
import io.nats.examples.chaosTestApp.support.ConsumerType;

public class CommandLineConsumer {
    public final ConsumerType consumerType;
    public final ConsumerKind consumerKind;
    public final int batchSize;
    public final long expiresIn;

    public CommandLineConsumer(String consumerKind) {
        this.consumerType = ConsumerType.Push;
        this.consumerKind = ConsumerKind.instance(consumerKind);
        this.batchSize = 0;
        this.expiresIn = 0L;
    }

    public CommandLineConsumer(String consumerType, String consumerKind, int batchSize, long expiresIn) {
        this.consumerType = ConsumerType.instance(consumerType);
        this.consumerKind = ConsumerKind.instance(consumerKind);
        if (batchSize < 1) {
            throw new IllegalArgumentException("Invalid Batch Size:" + batchSize);
        }
        this.batchSize = batchSize;
        if (expiresIn < 1000L) {
            throw new IllegalArgumentException("Expires must be >= 1000ms");
        }
        this.expiresIn = expiresIn;
    }

    public String toString() {
        if (this.consumerType == ConsumerType.Simple) {
            return this.consumerType.toString().toLowerCase() + " " + this.consumerKind.toString().toLowerCase() + " " + this.batchSize + " " + this.expiresIn;
        }
        return this.consumerType.toString().toLowerCase() + " " + this.consumerKind.toString().toLowerCase();
    }
}

