/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.PublishOptions;
import io.nats.client.api.PublishAck;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;

public class NatsJsPubWithOptionsUseCases {
    static final String usageString = "\nUsage: java -cp <classpath> NatsJsPubWithOptionsUseCases [-s server] [-strm stream] [-sub subject]\n\nDefault Values:\n   [-strm stream]     pubopts-stream\n   [-sub subject]     pubopts-subject\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Publish With Options Use Cases", args, usageString).defaultStream("pubopts-stream").defaultSubject("pubopts-subject").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            PublishOptions opts;
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            PublishOptions.Builder pubOptsBuilder = PublishOptions.builder().expectedStream(exArgs.stream).messageId("mid1");
            PublishAck pa = js.publish(exArgs.subject, "message1".getBytes(), pubOptsBuilder.build());
            System.out.printf("Published message on subject %s, stream %s, seqno %d.\n", exArgs.subject, pa.getStream(), pa.getSeqno());
            pubOptsBuilder.expectedLastMsgId("mid1").expectedLastSequence(-1L).messageId(null);
            pa = js.publish(exArgs.subject, "message2".getBytes(), pubOptsBuilder.build());
            System.out.printf("Published message on subject %s, stream %s, seqno %d.\n", exArgs.subject, pa.getStream(), pa.getSeqno());
            pubOptsBuilder.expectedLastMsgId(null).expectedLastSequence(pa.getSeqno()).messageId("mid3");
            pa = js.publish(exArgs.subject, "message3".getBytes(), pubOptsBuilder.build());
            System.out.printf("Published message on subject %s, stream %s, seqno %d.\n", exArgs.subject, pa.getStream(), pa.getSeqno());
            pubOptsBuilder.clearExpected().expectedLastSequence(pa.getSeqno()).messageId("mid4");
            pa = js.publish(exArgs.subject, "message4".getBytes(), pubOptsBuilder.build());
            System.out.printf("Published message on subject %s, stream %s, seqno %d.\n", exArgs.subject, pa.getStream(), pa.getSeqno());
            try {
                opts = PublishOptions.builder().expectedStream("wrongStream").build();
                js.publish(exArgs.subject, "ex1".getBytes(), opts);
            }
            catch (JetStreamApiException e) {
                System.out.format("Exception was: '%s'\n", e);
            }
            try {
                opts = PublishOptions.builder().expectedLastMsgId("wrongId").build();
                js.publish(exArgs.subject, "ex2".getBytes(), opts);
            }
            catch (JetStreamApiException e) {
                System.out.format("Exception was: '%s'\n", e);
            }
            try {
                opts = PublishOptions.builder().expectedLastSequence(999L).build();
                js.publish(exArgs.subject, "ex3".getBytes(), opts);
            }
            catch (JetStreamApiException e) {
                System.out.format("Exception was: '%s'\n", e);
            }
            jsm.deleteStream(exArgs.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

