/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class NatsJsPullSubFetchUseCases {
    static final String usageString = "\nUsage: java -cp <classpath> NatsJsPullSubFetchUseCases [-s server] [-strm stream] [-sub subject] [-dur durable] [-mcnt msgCount]\n\nDefault Values:\n   [-strm] fetch-uc-stream\n   [-sub]  fetch-uc-subject\n   [-dur]  fetch-uc-durable-not-required\n   [-mcnt] 15\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Pull Subscription using macro Fetch, Use Cases", args, usageString).defaultStream("fetch-uc-stream").defaultSubject("fetch-uc-subject").defaultDurable("fetch-uc-durable-not-required").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            ConsumerConfiguration cc = ConsumerConfiguration.builder().ackWait(Duration.ofMillis(2500L)).build();
            PullSubscribeOptions pullOptions = ((PullSubscribeOptions.Builder)((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().durable(exArgs.durable)).configuration(cc)).build();
            System.out.println("\n----------\n0. Initialize the subscription and pull.");
            JetStreamSubscription sub = js.subscribe(exArgs.subject, pullOptions);
            System.out.println("----------\n1. There are no messages yet");
            List<Message> messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 0 total messages, we received: " + messages.size());
            System.out.println("----------\n2. Publish 10 which satisfies the batch");
            NatsJsUtils.publish(js, exArgs.subject, "A", 10);
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n3. Publish 20 which is larger than the batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "B", 20);
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n4. Get the rest of the publish.");
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n5. Publish 5 which is less than batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "C", 5);
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 5 total messages, we received: " + messages.size());
            System.out.println("----------\n6. Publish 15 which is more than the batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "D", 15);
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n7. There are 5 messages left.");
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 5 messages, we received: " + messages.size());
            System.out.println("----------\n8. Fetch but don't ack.");
            NatsJsUtils.publish(js, exArgs.subject, "E", 10);
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            System.out.println("We should have received 10 message, we received: " + messages.size());
            ExampleUtils.sleep(3000L);
            System.out.println("----------\n9. Fetch, get the messages we did not ack.");
            messages = sub.fetch(10, Duration.ofSeconds(3L));
            NatsJsUtils.reportFetch(messages);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 message, we received: " + messages.size());
            System.out.println("----------\n");
            jsm.deleteStream(exArgs.stream);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (JetStreamApiException | IOException | InterruptedException e) {
            System.err.println(e);
        }
    }
}

