/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueManagement;
import io.nats.client.Nats;
import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.KeyValueEntry;
import io.nats.client.api.KeyValueStatus;
import io.nats.client.api.StorageType;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;

public class NatsKeyValueFull {
    static final String usageString = "\nUsage: java -cp <classpath> NatsKeyValueFull [-s server] [-buk bucket] [-d description]\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";
    private static final String BYTE_KEY = "byteKey";
    private static final String STRING_KEY = "stringKey";
    private static final String LONG_KEY = "longKey";
    private static final String NOT_FOUND = "notFound";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Key Value Full Example", args, usageString).defaultBucket("exampleBucket").defaultDescription("Example Description").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            KeyValueManagement kvm = nc.keyValueManagement();
            KeyValueConfiguration kvc = KeyValueConfiguration.builder().name(exArgs.bucket).description(exArgs.description).maxHistoryPerKey(5).storageType(StorageType.Memory).build();
            KeyValueStatus kvs = kvm.create(kvc);
            System.out.println(kvs);
            KeyValue kv = nc.keyValue(exArgs.bucket);
            System.out.println("\n1. Put");
            long seq = kv.put(BYTE_KEY, "Byte Value 1".getBytes());
            System.out.println("Revision number should be 1, got " + seq);
            seq = kv.put(STRING_KEY, "String Value 1");
            System.out.println("Revision number should be 2, got " + seq);
            seq = kv.put(LONG_KEY, 1);
            System.out.println("Revision number should be 3, got " + seq);
            System.out.println("\n2. Get Value (Bytes)");
            byte[] bvalue = kv.get(BYTE_KEY).getValue();
            System.out.println("byteKey from getValue: " + new String(bvalue));
            bvalue = kv.get(STRING_KEY).getValue();
            System.out.println("stringKey from getValue: " + new String(bvalue));
            bvalue = kv.get(LONG_KEY).getValue();
            System.out.println("longKey from getValue: " + new String(bvalue));
            System.out.println("\n3. Get String Value");
            String svalue = kv.get(BYTE_KEY).getValueAsString();
            System.out.println("byteKey from getValueAsString: " + svalue);
            svalue = kv.get(STRING_KEY).getValueAsString();
            System.out.println("stringKey from getValueAsString: " + svalue);
            svalue = kv.get(LONG_KEY).getValueAsString();
            System.out.println("longKey from getValueAsString: " + svalue);
            System.out.println("\n4. Get Long Value");
            Long lvalue = kv.get(LONG_KEY).getValueAsLong();
            System.out.println("longKey from getValueAsLong: " + lvalue);
            try {
                kv.get(STRING_KEY).getValueAsLong();
            }
            catch (NumberFormatException nfe) {
                System.out.println("stringKey value is not a long!");
            }
            System.out.println("\n5. Get Entry");
            KeyValueEntry entry = kv.get(BYTE_KEY);
            System.out.println("byteKey entry: " + entry);
            entry = kv.get(STRING_KEY);
            System.out.println("stringKey entry: " + entry);
            entry = kv.get(LONG_KEY);
            System.out.println("longKey entry: " + entry);
            System.out.println("\n6. Delete a key");
            kv.delete(BYTE_KEY);
            KeyValueEntry kve = kv.get(BYTE_KEY);
            System.out.println("Deleted key, result of get should be null: " + kve);
            System.out.println("\n7. Keys does not exist");
            kve = kv.get(NOT_FOUND);
            System.out.println("Entry for notFound should be null: " + kve);
            System.out.println("\n8.1 Update values");
            seq = kv.put(BYTE_KEY, "Byte Value 2".getBytes());
            System.out.println("Revision number should be 5, got " + seq);
            seq = kv.put(STRING_KEY, "String Value 2");
            System.out.println("Revision number should be 6, got " + seq);
            seq = kv.put(LONG_KEY, 2);
            System.out.println("Revision number should be 7, got " + seq);
            System.out.println("\n8.2 Values after update");
            svalue = kv.get(BYTE_KEY).getValueAsString();
            System.out.println("byteKey from getValueAsString: " + svalue);
            svalue = kv.get(STRING_KEY).getValueAsString();
            System.out.println("stringKey from getValueAsString: " + svalue);
            lvalue = kv.get(LONG_KEY).getValueAsLong();
            System.out.println("longKey from getValueAsLong: " + lvalue);
            System.out.println("\n9.1 Bucket before update/delete");
            kvs = kvm.getStatus(exArgs.bucket);
            System.out.println(kvs);
            kvc = KeyValueConfiguration.builder(kvs.getConfiguration()).description(exArgs.description + "-changed").maxHistoryPerKey(6).build();
            kvs = kvm.update(kvc);
            System.out.println("\n9.2 Bucket after update");
            System.out.println(kvs);
            System.out.println("\n9.3 Delete");
            kvm.delete(exArgs.bucket);
            try {
                kvm.getStatus(exArgs.bucket);
                System.out.println("UH OH! Bucket should not have been found!");
            }
            catch (JetStreamApiException e) {
                System.out.println("Bucket was not found!");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

