/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream.simple;

import io.nats.client.Connection;
import io.nats.client.ConsumerContext;
import io.nats.client.IterableConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.jetstream.NatsJsUtils;
import io.nats.examples.jetstream.ResilientPublisher;
import java.io.IOException;

public class IterableConsumerExample {
    private static final String STREAM = "iterable-stream";
    private static final String SUBJECT = "iterable-subject";
    private static final String CONSUMER_NAME = "iterable-consumer";
    private static final String MESSAGE_PREFIX = "iterable";
    private static final int STOP_COUNT = 500;
    private static final int REPORT_EVERY = 50;
    private static final String SERVER = "nats://localhost:4222";

    public static void main(String[] args) {
        Options options = Options.builder().server(SERVER).build();
        try (Connection nc = Nats.connect(options);){
            ConsumerContext consumerContext;
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createOrReplaceStream(jsm, STREAM, SUBJECT);
            try {
                StreamContext streamContext = nc.getStreamContext(STREAM);
                consumerContext = streamContext.createOrUpdateConsumer(ConsumerConfiguration.builder().durable(CONSUMER_NAME).build());
            }
            catch (JetStreamApiException | IOException e) {
                if (nc != null) {
                    if (var3_4 != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        nc.close();
                    }
                }
                return;
            }
            System.out.println("Starting publish...");
            ResilientPublisher publisher = new ResilientPublisher(nc, jsm, STREAM, SUBJECT).basicDataPrefix(MESSAGE_PREFIX).jitter(10L);
            Thread pubThread = new Thread(publisher);
            pubThread.start();
            Thread consumeThread = new Thread(() -> {
                int count = 0;
                long start = System.currentTimeMillis();
                try (IterableConsumer consumer = consumerContext.iterate();){
                    Message msg;
                    System.out.println("Starting main loop.");
                    while (count < 500) {
                        msg = consumer.nextMessage(1000L);
                        if (msg == null) continue;
                        msg.ack();
                        if (++count % 50 != 0) continue;
                        IterableConsumerExample.report("Main loop running", System.currentTimeMillis() - start, count);
                    }
                    IterableConsumerExample.report("Main loop stopped", System.currentTimeMillis() - start, count);
                    consumer.stop();
                    System.out.println("Starting post-stop loop.");
                    while (!consumer.isFinished()) {
                        msg = consumer.nextMessage(1000L);
                        if (msg == null) continue;
                        msg.ack();
                        if (++count % 50 != 0) continue;
                        IterableConsumerExample.report("Post-stop loop running", System.currentTimeMillis() - start, ++count);
                    }
                    IterableConsumerExample.report("Post-stop loop stopped", System.currentTimeMillis() - start, count);
                }
                catch (JetStreamApiException | JetStreamStatusCheckedException | IOException | InterruptedException e) {
                    System.err.println("Exception should be handled properly, just exiting here.");
                    System.exit(-1);
                }
                catch (Exception e) {
                    System.err.println("Exception should be handled properly, just exiting here.");
                    System.exit(-1);
                }
                IterableConsumerExample.report("Done", System.currentTimeMillis() - start, count);
            });
            consumeThread.start();
            consumeThread.join();
            publisher.stop();
            pubThread.join();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    private static void report(String label, long ms, int count) {
        System.out.println(label + ": Received " + count + " messages in " + ms + "ms.");
    }
}

