/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AuthHandler;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.impl.DataPort;
import io.nats.client.impl.SSLUtils;
import io.nats.client.impl.SocketDataPort;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public class Options {
    public static final String DEFAULT_URL = "nats://localhost:4222";
    public static final int DEFAULT_PORT = 4222;
    public static final int DEFAULT_MAX_RECONNECT = 60;
    public static final Duration DEFAULT_RECONNECT_WAIT = Duration.ofSeconds(2L);
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(2L);
    public static final Duration DEFAULT_PING_INTERVAL = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_REQUEST_CLEANUP_INTERVAL = Duration.ofSeconds(5L);
    public static final int DEFAULT_MAX_PINGS_OUT = 2;
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final int DEFAULT_RECONNECT_BUF_SIZE = 0x800000;
    public static final int DEFAULT_MAX_CONTROL_LINE = 1024;
    public static final String DEFAULT_DATA_PORT_TYPE = SocketDataPort.class.getCanonicalName();
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final String DEFAULT_INBOX_PREFIX = "_INBOX.";
    static final String PFX = "io.nats.client.";
    public static final String PROP_CONNECTION_CB = "io.nats.client.callback.connection";
    public static final String PROP_DATA_PORT_TYPE = "io.nats.client.dataport.type";
    public static final String PROP_ERROR_LISTENER = "io.nats.client.callback.error";
    public static final String PROP_MAX_PINGS = "io.nats.client.maxpings";
    public static final String PROP_PING_INTERVAL = "io.nats.client.pinginterval";
    public static final String PROP_CLEANUP_INTERVAL = "io.nats.client.cleanupinterval";
    public static final String PROP_CONNECTION_TIMEOUT = "io.nats.client.timeout";
    public static final String PROP_RECONNECT_BUF_SIZE = "io.nats.client.reconnect.buffer.size";
    public static final String PROP_RECONNECT_WAIT = "io.nats.client.reconnect.wait";
    public static final String PROP_MAX_RECONNECT = "io.nats.client.reconnect.max";
    public static final String PROP_PEDANTIC = "io.nats.client.pedantic";
    public static final String PROP_VERBOSE = "io.nats.client.verbose";
    public static final String PROP_NO_ECHO = "io.nats.client.noecho";
    public static final String PROP_CONNECTION_NAME = "io.nats.client.name";
    public static final String PROP_NORANDOMIZE = "io.nats.client.norandomize";
    public static final String PROP_SERVERS = "io.nats.client.servers";
    public static final String PROP_PASSWORD = "io.nats.client.password";
    public static final String PROP_USERNAME = "io.nats.client.username";
    public static final String PROP_TOKEN = "io.nats.client.token";
    public static final String PROP_URL = "io.nats.client.url";
    public static final String PROP_SECURE = "io.nats.client.secure";
    public static final String PROP_OPENTLS = "io.nats.client.opentls";
    public static final String PROP_USE_OLD_REQUEST_STYLE = "use.old.request.style";
    public static final String PROP_MAX_CONTROL_LINE = "max.control.line";
    public static final String PROP_UTF8_SUBJECTS = "allow.utf8.subjects";
    public static final String PROP_INBOX_PREFIX = "inbox.prefix";
    static final String OPTION_VERBOSE = "verbose";
    static final String OPTION_PEDANTIC = "pedantic";
    static final String OPTION_TLS_REQUIRED = "tls_required";
    static final String OPTION_AUTH_TOKEN = "auth_token";
    static final String OPTION_USER = "user";
    static final String OPTION_PASSWORD = "pass";
    static final String OPTION_NAME = "name";
    static final String OPTION_LANG = "lang";
    static final String OPTION_VERSION = "version";
    static final String OPTION_PROTOCOL = "protocol";
    static final String OPTION_ECHO = "echo";
    static final String OPTION_NKEY = "nkey";
    static final String OPTION_SIG = "sig";
    static final String OPTION_JWT = "jwt";
    private List<URI> servers;
    private final boolean noRandomize;
    private final String connectionName;
    private final boolean verbose;
    private final boolean pedantic;
    private final SSLContext sslContext;
    private final int maxReconnect;
    private final int maxControlLine;
    private final Duration reconnectWait;
    private final Duration connectionTimeout;
    private final Duration pingInterval;
    private final Duration requestCleanupInterval;
    private final int maxPingsOut;
    private final long reconnectBufferSize;
    private final String username;
    private final String password;
    private final String token;
    private final String inboxPrefix;
    private final boolean useOldRequestStyle;
    private final int bufferSize;
    private final boolean noEcho;
    private final boolean utf8Support;
    private final AuthHandler authHandler;
    private final ErrorListener errorListener;
    private final ConnectionListener connectionListener;
    private final String dataPortType;
    private final boolean trackAdvancedStats;

    private Options(Builder b) {
        this.servers = b.servers;
        this.noRandomize = b.noRandomize;
        this.connectionName = b.connectionName;
        this.verbose = b.verbose;
        this.pedantic = b.pedantic;
        this.sslContext = b.sslContext;
        this.maxReconnect = b.maxReconnect;
        this.reconnectWait = b.reconnectWait;
        this.connectionTimeout = b.connectionTimeout;
        this.pingInterval = b.pingInterval;
        this.requestCleanupInterval = b.requestCleanupInterval;
        this.maxPingsOut = b.maxPingsOut;
        this.reconnectBufferSize = b.reconnectBufferSize;
        this.username = b.username;
        this.password = b.password;
        this.token = b.token;
        this.useOldRequestStyle = b.useOldRequestStyle;
        this.maxControlLine = b.maxControlLine;
        this.bufferSize = b.bufferSize;
        this.noEcho = b.noEcho;
        this.utf8Support = b.utf8Support;
        this.inboxPrefix = b.inboxPrefix;
        this.authHandler = b.authHandler;
        this.errorListener = b.errorListener;
        this.connectionListener = b.connectionListener;
        this.dataPortType = b.dataPortType;
        this.trackAdvancedStats = b.trackAdvancedStats;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public AuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public String getDataPortType() {
        return this.dataPortType;
    }

    public DataPort buildDataPort() {
        return (DataPort)Builder.createInstanceOf(this.dataPortType);
    }

    public Collection<URI> getServers() {
        return this.servers;
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    public boolean supportUTF8Subjects() {
        return this.utf8Support;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public boolean isTrackAdvancedStats() {
        return this.trackAdvancedStats;
    }

    public int getMaxControlLine() {
        return this.maxControlLine;
    }

    public boolean isTLSRequired() {
        return this.sslContext != null;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public Duration getReconnectWait() {
        return this.reconnectWait;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public Duration getRequestCleanupInterval() {
        return this.requestCleanupInterval;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public long getReconnectBufferSize() {
        return this.reconnectBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isOldRequestStyle() {
        return this.useOldRequestStyle;
    }

    public String getInboxPrefix() {
        return this.inboxPrefix;
    }

    public URI createURIForServer(String serverURI) throws URISyntaxException {
        return Options.parseURIForServer(serverURI);
    }

    static URI parseURIForServer(String serverURI) throws URISyntaxException {
        String[] known = new String[]{"nats", "tls", "opentls"};
        List<String> knownProtocols = Arrays.asList(known);
        URI uri = null;
        try {
            uri = new URI(serverURI);
            if (uri.getHost() == null || uri.getHost().equals("") || uri.getScheme() == "" || uri.getScheme() == null) {
                uri = new URI("nats://" + serverURI);
            }
        }
        catch (URISyntaxException e) {
            uri = new URI("nats://" + serverURI);
        }
        if (!knownProtocols.contains(uri.getScheme())) {
            throw new URISyntaxException(serverURI, "unknown URI scheme ");
        }
        if (uri.getHost() != null && uri.getHost() != "") {
            if (uri.getPort() == -1) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 4222, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        throw new URISyntaxException(serverURI, "unable to parse server URI");
    }

    public String buildProtocolConnectOptionsString(String serverURI, boolean includeAuth, byte[] nonce) {
        StringBuilder connectString = new StringBuilder();
        connectString.append("{");
        this.appendOption(connectString, OPTION_LANG, "java", true, false);
        this.appendOption(connectString, OPTION_VERSION, "2.4.0", true, true);
        if (this.connectionName != null) {
            this.appendOption(connectString, OPTION_NAME, this.connectionName, true, true);
        }
        this.appendOption(connectString, OPTION_PROTOCOL, "1", false, true);
        this.appendOption(connectString, OPTION_VERBOSE, String.valueOf(this.isVerbose()), false, true);
        this.appendOption(connectString, OPTION_PEDANTIC, String.valueOf(this.isPedantic()), false, true);
        this.appendOption(connectString, OPTION_TLS_REQUIRED, String.valueOf(this.isTLSRequired()), false, true);
        this.appendOption(connectString, OPTION_ECHO, String.valueOf(!this.isNoEcho()), false, true);
        if (includeAuth && nonce != null && this.getAuthHandler() != null) {
            char[] nkey = this.getAuthHandler().getID();
            byte[] sig = this.getAuthHandler().sign(nonce);
            char[] jwt = this.getAuthHandler().getJWT();
            if (sig == null) {
                sig = new byte[]{};
            }
            if (jwt == null) {
                jwt = new char[]{};
            }
            if (nkey == null) {
                nkey = new char[]{};
            }
            String encodedSig = Base64.getUrlEncoder().withoutPadding().encodeToString(sig);
            this.appendOption(connectString, OPTION_NKEY, new String(nkey), true, true);
            this.appendOption(connectString, OPTION_SIG, encodedSig, true, true);
            this.appendOption(connectString, OPTION_JWT, new String(jwt), true, true);
        } else if (includeAuth) {
            String uriUser = null;
            String uriPass = null;
            String uriToken = null;
            try {
                URI uri = this.createURIForServer(serverURI);
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String[] info = userInfo.split(":");
                    if (info.length == 2) {
                        uriUser = info[0];
                        uriPass = info[1];
                    } else {
                        uriToken = userInfo;
                    }
                }
            }
            catch (URISyntaxException e) {
                uriPass = null;
                uriToken = null;
                uriUser = null;
            }
            if (uriUser != null) {
                this.appendOption(connectString, OPTION_USER, uriUser, true, true);
            } else if (this.username != null) {
                this.appendOption(connectString, OPTION_USER, this.username, true, true);
            }
            if (uriPass != null) {
                this.appendOption(connectString, OPTION_PASSWORD, uriPass, true, true);
            } else if (this.password != null) {
                this.appendOption(connectString, OPTION_PASSWORD, this.password, true, true);
            }
            if (uriToken != null) {
                this.appendOption(connectString, OPTION_AUTH_TOKEN, uriToken, true, true);
            } else if (this.token != null) {
                this.appendOption(connectString, OPTION_AUTH_TOKEN, this.token, true, true);
            }
        }
        connectString.append("}");
        return connectString.toString();
    }

    private void appendOption(StringBuilder builder, String key, String value, boolean quotes, boolean comma) {
        if (comma) {
            builder.append(",");
        }
        builder.append("\"");
        builder.append(key);
        builder.append("\"");
        builder.append(":");
        if (quotes) {
            builder.append("\"");
        }
        builder.append(value);
        if (quotes) {
            builder.append("\"");
        }
    }

    public static class Builder {
        private ArrayList<URI> servers = new ArrayList();
        private boolean noRandomize = false;
        private String connectionName = null;
        private boolean verbose = false;
        private boolean pedantic = false;
        private SSLContext sslContext = null;
        private int maxControlLine = 1024;
        private int maxReconnect = 60;
        private Duration reconnectWait = DEFAULT_RECONNECT_WAIT;
        private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        private Duration pingInterval = DEFAULT_PING_INTERVAL;
        private Duration requestCleanupInterval = DEFAULT_REQUEST_CLEANUP_INTERVAL;
        private int maxPingsOut = 2;
        private long reconnectBufferSize = 0x800000L;
        private String username = null;
        private String password = null;
        private String token = null;
        private boolean useOldRequestStyle = false;
        private int bufferSize = 65536;
        private boolean trackAdvancedStats = false;
        private boolean noEcho = false;
        private boolean utf8Support = false;
        private String inboxPrefix = "_INBOX.";
        private AuthHandler authHandler;
        private ErrorListener errorListener = null;
        private ConnectionListener connectionListener = null;
        private String dataPortType = DEFAULT_DATA_PORT_TYPE;

        public Builder() {
        }

        public Builder(Properties props) throws IllegalArgumentException {
            Object instance;
            boolean tls;
            boolean secure;
            if (props == null) {
                throw new IllegalArgumentException("Properties cannot be null");
            }
            if (props.containsKey(Options.PROP_URL)) {
                this.server(props.getProperty(Options.PROP_URL, Options.DEFAULT_URL));
            }
            if (props.containsKey(Options.PROP_USERNAME)) {
                this.username = props.getProperty(Options.PROP_USERNAME, null);
            }
            if (props.containsKey(Options.PROP_PASSWORD)) {
                this.password = props.getProperty(Options.PROP_PASSWORD, null);
            }
            if (props.containsKey(Options.PROP_TOKEN)) {
                this.token = props.getProperty(Options.PROP_TOKEN, null);
            }
            if (props.containsKey(Options.PROP_SERVERS)) {
                String str = props.getProperty(Options.PROP_SERVERS);
                if (str.isEmpty()) {
                    throw new IllegalArgumentException("io.nats.client.servers cannot be empty");
                }
                String[] servers = str.trim().split(",\\s*");
                this.servers(servers);
            }
            if (props.containsKey(Options.PROP_NORANDOMIZE)) {
                this.noRandomize = Boolean.parseBoolean(props.getProperty(Options.PROP_NORANDOMIZE));
            }
            if (props.containsKey(Options.PROP_SECURE) && (secure = Boolean.parseBoolean(props.getProperty(Options.PROP_SECURE)))) {
                try {
                    this.sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    this.sslContext = null;
                    throw new IllegalArgumentException("Unable to retrieve default SSL context");
                }
            }
            if (props.containsKey(Options.PROP_OPENTLS) && (tls = Boolean.parseBoolean(props.getProperty(Options.PROP_OPENTLS)))) {
                try {
                    this.sslContext = SSLUtils.createOpenTLSContext();
                }
                catch (Exception e) {
                    this.sslContext = null;
                    throw new IllegalArgumentException("Unable to create open SSL context");
                }
            }
            if (props.containsKey(Options.PROP_CONNECTION_NAME)) {
                this.connectionName = props.getProperty(Options.PROP_CONNECTION_NAME, null);
            }
            if (props.containsKey(Options.PROP_VERBOSE)) {
                this.verbose = Boolean.parseBoolean(props.getProperty(Options.PROP_VERBOSE));
            }
            if (props.containsKey(Options.PROP_NO_ECHO)) {
                this.noEcho = Boolean.parseBoolean(props.getProperty(Options.PROP_NO_ECHO));
            }
            if (props.containsKey(Options.PROP_UTF8_SUBJECTS)) {
                this.utf8Support = Boolean.parseBoolean(props.getProperty(Options.PROP_UTF8_SUBJECTS));
            }
            if (props.containsKey(Options.PROP_PEDANTIC)) {
                this.pedantic = Boolean.parseBoolean(props.getProperty(Options.PROP_PEDANTIC));
            }
            if (props.containsKey(Options.PROP_MAX_RECONNECT)) {
                this.maxReconnect = Integer.parseInt(props.getProperty(Options.PROP_MAX_RECONNECT, Integer.toString(60)));
            }
            if (props.containsKey(Options.PROP_RECONNECT_WAIT)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_RECONNECT_WAIT, "-1"));
                Duration duration = this.reconnectWait = ms < 0 ? DEFAULT_RECONNECT_WAIT : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_RECONNECT_BUF_SIZE)) {
                this.reconnectBufferSize = Long.parseLong(props.getProperty(Options.PROP_RECONNECT_BUF_SIZE, Long.toString(0x800000L)));
            }
            if (props.containsKey(Options.PROP_CONNECTION_TIMEOUT)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_CONNECTION_TIMEOUT, "-1"));
                Duration duration = this.connectionTimeout = ms < 0 ? DEFAULT_CONNECTION_TIMEOUT : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_MAX_CONTROL_LINE)) {
                int bytes = Integer.parseInt(props.getProperty(Options.PROP_MAX_CONTROL_LINE, "-1"));
                int n = this.maxControlLine = bytes < 0 ? 1024 : bytes;
            }
            if (props.containsKey(Options.PROP_PING_INTERVAL)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_PING_INTERVAL, "-1"));
                Duration duration = this.pingInterval = ms < 0 ? DEFAULT_PING_INTERVAL : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_CLEANUP_INTERVAL)) {
                int ms = Integer.parseInt(props.getProperty(Options.PROP_CLEANUP_INTERVAL, "-1"));
                Duration duration = this.requestCleanupInterval = ms < 0 ? DEFAULT_REQUEST_CLEANUP_INTERVAL : Duration.ofMillis(ms);
            }
            if (props.containsKey(Options.PROP_MAX_PINGS)) {
                this.maxPingsOut = Integer.parseInt(props.getProperty(Options.PROP_MAX_PINGS, Integer.toString(2)));
            }
            if (props.containsKey(Options.PROP_USE_OLD_REQUEST_STYLE)) {
                this.useOldRequestStyle = Boolean.parseBoolean(props.getProperty(Options.PROP_USE_OLD_REQUEST_STYLE));
            }
            if (props.containsKey(Options.PROP_ERROR_LISTENER)) {
                instance = Builder.createInstanceOf(props.getProperty(Options.PROP_ERROR_LISTENER));
                this.errorListener = (ErrorListener)instance;
            }
            if (props.containsKey(Options.PROP_CONNECTION_CB)) {
                instance = Builder.createInstanceOf(props.getProperty(Options.PROP_CONNECTION_CB));
                this.connectionListener = (ConnectionListener)instance;
            }
            if (props.containsKey(Options.PROP_DATA_PORT_TYPE)) {
                this.dataPortType = props.getProperty(Options.PROP_DATA_PORT_TYPE);
            }
            if (props.containsKey(Options.PROP_INBOX_PREFIX)) {
                this.inboxPrefix(props.getProperty(Options.PROP_INBOX_PREFIX, Options.DEFAULT_INBOX_PREFIX));
            }
        }

        static Object createInstanceOf(String className) {
            Object instance = null;
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            return instance;
        }

        public Builder server(String serverURL) {
            try {
                this.servers.add(Options.parseURIForServer(serverURL.trim()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Bad server URL: " + serverURL, e);
            }
            return this;
        }

        public Builder servers(String[] servers) {
            for (String s : servers) {
                if (s == null || s.isEmpty()) continue;
                try {
                    this.servers.add(Options.parseURIForServer(s.trim()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Bad server URL: " + s, e);
                }
            }
            return this;
        }

        public Builder oldRequestStyle() {
            this.useOldRequestStyle = true;
            return this;
        }

        public Builder noRandomize() {
            this.noRandomize = true;
            return this;
        }

        public Builder noEcho() {
            this.noEcho = true;
            return this;
        }

        public Builder supportUTF8Subjects() {
            this.utf8Support = true;
            return this;
        }

        public Builder connectionName(String name) {
            this.connectionName = name;
            return this;
        }

        public Builder inboxPrefix(String prefix) {
            this.inboxPrefix = prefix;
            if (!this.inboxPrefix.endsWith(".")) {
                this.inboxPrefix = this.inboxPrefix + ".";
            }
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder pedantic() {
            this.pedantic = true;
            return this;
        }

        public Builder turnOnAdvancedStats() {
            this.trackAdvancedStats = true;
            return this;
        }

        public Builder secure() throws NoSuchAlgorithmException, IllegalArgumentException {
            this.sslContext = SSLContext.getDefault();
            if (this.sslContext == null) {
                throw new IllegalArgumentException("No Default SSL Context");
            }
            return this;
        }

        public Builder opentls() throws NoSuchAlgorithmException {
            this.sslContext = SSLUtils.createOpenTLSContext();
            return this;
        }

        public Builder sslContext(SSLContext ctx) {
            this.sslContext = ctx;
            return this;
        }

        public Builder noReconnect() {
            this.maxReconnect = 0;
            return this;
        }

        public Builder maxReconnects(int max) {
            this.maxReconnect = max;
            return this;
        }

        public Builder reconnectWait(Duration time) {
            this.reconnectWait = time;
            return this;
        }

        public Builder maxControlLine(int bytes) {
            this.maxControlLine = bytes;
            return this;
        }

        public Builder connectionTimeout(Duration time) {
            this.connectionTimeout = time;
            return this;
        }

        public Builder pingInterval(Duration time) {
            this.pingInterval = time;
            return this;
        }

        public Builder requestCleanupInterval(Duration time) {
            this.requestCleanupInterval = time;
            return this;
        }

        public Builder maxPingsOut(int max) {
            this.maxPingsOut = max;
            return this;
        }

        public Builder bufferSize(int size) {
            this.bufferSize = size;
            return this;
        }

        public Builder reconnectBufferSize(long size) {
            this.reconnectBufferSize = size;
            return this;
        }

        public Builder userInfo(String userName, String password) {
            this.username = userName;
            this.password = password;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder authHandler(AuthHandler handler) {
            this.authHandler = handler;
            return this;
        }

        public Builder errorListener(ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder connectionListener(ConnectionListener listener) {
            this.connectionListener = listener;
            return this;
        }

        public Builder dataPortType(String dataPortClassName) {
            this.dataPortType = dataPortClassName;
            return this;
        }

        public Options build() throws IllegalStateException {
            if (this.username != null && this.token != null) {
                throw new IllegalStateException("Options can't have token and username");
            }
            if (this.servers.size() == 0) {
                this.server(Options.DEFAULT_URL);
            } else if (this.servers.size() == 1) {
                URI serverURI = this.servers.get(0);
                if ("tls".equals(serverURI.getScheme()) && this.sslContext == null) {
                    try {
                        this.sslContext = SSLContext.getDefault();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Unable to create default SSL context", e);
                    }
                } else if ("opentls".equals(serverURI.getScheme()) && this.sslContext == null) {
                    this.sslContext = SSLUtils.createOpenTLSContext();
                }
            }
            return new Options(this);
        }
    }
}

