/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.impl.NatsSubscription;
import java.nio.charset.StandardCharsets;

class NatsMessage
implements Message {
    private String sid;
    private String subject;
    private String replyTo;
    private byte[] data;
    private byte[] protocolBytes;
    private NatsSubscription subscription;
    private long sizeInBytes;
    NatsMessage next;
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static String PUB_SPACE = "PUB ";
    private static String SPACE = " ";

    static int copy(byte[] dest, int pos, String toCopy) {
        int max = toCopy.length();
        for (int i = 0; i < max; ++i) {
            dest[pos] = (byte)toCopy.charAt(i);
            ++pos;
        }
        return pos;
    }

    NatsMessage(String subject, String replyTo, byte[] data, boolean utf8mode) {
        this.subject = subject;
        this.replyTo = replyTo;
        this.data = data;
        if (utf8mode) {
            int subjectSize = subject.length() * 2;
            int replySize = replyTo != null ? replyTo.length() * 2 : 0;
            StringBuilder protocolStringBuilder = new StringBuilder(4 + subjectSize + 1 + replySize + 1);
            protocolStringBuilder.append(PUB_SPACE);
            protocolStringBuilder.append(subject);
            protocolStringBuilder.append(SPACE);
            if (replyTo != null) {
                protocolStringBuilder.append(replyTo);
                protocolStringBuilder.append(SPACE);
            }
            protocolStringBuilder.append(String.valueOf(data.length));
            this.protocolBytes = protocolStringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        } else {
            int size;
            byte[] lengthBytes = new byte[12];
            int idx = lengthBytes.length;
            int n = size = data != null ? data.length : 0;
            if (size > 0) {
                for (int i = size; i > 0; i /= 10) {
                    lengthBytes[--idx] = digits[i % 10];
                }
            } else {
                lengthBytes[--idx] = digits[0];
            }
            int len = 4 + subject.length() + 1 + (lengthBytes.length - idx);
            if (replyTo != null) {
                len += replyTo.length() + 1;
            }
            this.protocolBytes = new byte[len];
            int pos = 0;
            this.protocolBytes[0] = 80;
            this.protocolBytes[1] = 85;
            this.protocolBytes[2] = 66;
            this.protocolBytes[3] = 32;
            pos = 4;
            pos = NatsMessage.copy(this.protocolBytes, pos, subject);
            this.protocolBytes[pos] = 32;
            ++pos;
            if (replyTo != null) {
                pos = NatsMessage.copy(this.protocolBytes, pos, replyTo);
                this.protocolBytes[pos] = 32;
                ++pos;
            }
            System.arraycopy(lengthBytes, idx, this.protocolBytes, pos, lengthBytes.length - idx);
        }
        this.sizeInBytes = this.protocolBytes.length + data.length + 4;
    }

    NatsMessage(String protocol) {
        this.protocolBytes = protocol.getBytes(StandardCharsets.UTF_8);
        this.sizeInBytes = this.protocolBytes.length + 2;
    }

    NatsMessage(String sid, String subject, String replyTo, int protocolLength) {
        this.sid = sid;
        this.subject = subject;
        if (replyTo != null) {
            this.replyTo = replyTo;
        }
        this.sizeInBytes = protocolLength + 2;
        this.data = null;
    }

    boolean isProtocol() {
        return this.subject == null;
    }

    byte[] getProtocolBytes() {
        return this.protocolBytes;
    }

    int getControlLineLength() {
        return this.protocolBytes != null ? this.protocolBytes.length + 2 : -1;
    }

    long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public String getSID() {
        return this.sid;
    }

    void setData(byte[] data) {
        this.data = data;
        this.sizeInBytes += (long)(data.length + 2);
    }

    void setSubscription(NatsSubscription sub) {
        this.subscription = sub;
    }

    NatsSubscription getNatsSubscription() {
        return this.subscription;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }
}

