/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse;

import io.nats.jparse.node.ArrayNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.ObjectNode;
import io.nats.jparse.node.RootNode;
import io.nats.jparse.parser.JsonParser;
import io.nats.jparse.parser.JsonParserBuilder;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Json {
    private static final AtomicReference<JsonParserBuilder> builderRef = new AtomicReference<JsonParserBuilder>(new JsonParserBuilder().setStrict(false));
    private static final JsonParser PARSER = Json.builder().build();
    public static String J_PARSE_JSON_STRICT = "J_PARSE_JSON_STRICT";
    public static String J_OBJECT_KEY_CAN_BE_ENCODED = "J_OBJECT_KEY_CAN_BE_ENCODED";

    private Json() {
    }

    public static JsonParserBuilder builder() {
        return builderRef.get().cloneBuilder();
    }

    public static String niceJson(String json) {
        char[] chars = json.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (char c : chars) {
            if (c == '\'') {
                sb.append('\"');
                continue;
            }
            if (c == '`') {
                sb.append('\\');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static ArrayNode toArrayNode(String json) {
        return PARSER.parse(json).getArrayNode();
    }

    public static ObjectNode toObjectNode(String json) {
        return PARSER.parse(json).getObjectNode();
    }

    public static RootNode toRootNode(String json) {
        return PARSER.parse(json);
    }

    public static List<Object> toList(String json) {
        return Json.toArrayNode(json);
    }

    public static Map<String, Object> toMap(String json) {
        return Json.toObjectNode(json);
    }

    public static List<Token> toTokens(String json) {
        return PARSER.scan(json);
    }

    public static ArrayNode toArrayNode(CharSource json) {
        return PARSER.parse(json).getArrayNode();
    }

    public static ObjectNode toObjectNode(CharSource json) {
        return PARSER.parse(json).getObjectNode();
    }

    public static RootNode toRootNode(CharSource json) {
        return PARSER.parse(json);
    }

    public static List<Object> toList(CharSource json) {
        return PARSER.parse(json).getArrayNode();
    }

    public static Map<String, Object> toMap(CharSource json) {
        return PARSER.parse(json).getObjectNode();
    }

    public static List<Token> toTokens(CharSource json) {
        return PARSER.scan(json);
    }

    public static String serializeToString(Object object) {
        return ((Node)object).originalString();
    }

    public static CharSequence serialize(Object object) {
        return ((Node)object).originalCharSequence();
    }

    static {
        try {
            String strObjectsKeysCanBeEncoded;
            String strStrict = System.getenv(J_PARSE_JSON_STRICT);
            if (strStrict != null) {
                if (strStrict.equalsIgnoreCase("false")) {
                    builderRef.set(builderRef.get().cloneBuilder().setStrict(false));
                } else {
                    builderRef.set(builderRef.get().cloneBuilder().setStrict(true));
                }
            }
            if ((strObjectsKeysCanBeEncoded = System.getenv(J_OBJECT_KEY_CAN_BE_ENCODED)) != null) {
                if (strObjectsKeysCanBeEncoded.equalsIgnoreCase("false")) {
                    builderRef.set(builderRef.get().cloneBuilder().setObjectsKeysCanBeEncoded(false));
                } else {
                    builderRef.set(builderRef.get().cloneBuilder().setObjectsKeysCanBeEncoded(true));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

