/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse;

import io.nats.jparse.Json;
import io.nats.jparse.node.ArrayNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.ObjectNode;
import io.nats.jparse.path.PathElement;
import io.nats.jparse.path.PathNode;
import io.nats.jparse.path.PathParser;
import io.nats.jparse.source.support.PathException;
import java.util.Iterator;

public class Path {
    private Path() {
    }

    public static Node atPath(String path, String json) {
        return Path.atPath(path, (Node)Json.toRootNode(json));
    }

    public static Node atPath(String path, Node rootNode) {
        return Path.atPath(Path.toPath(path), rootNode);
    }

    public static Node atPath(PathNode path, Node rootNode) {
        Iterator<PathElement> iterator = path.iterator();
        Node node = rootNode;
        PathElement pathElement = null;
        try {
            block6: while (iterator.hasNext()) {
                pathElement = iterator.next();
                switch (node.type()) {
                    case OBJECT: {
                        ObjectNode objectNode = (ObjectNode)node;
                        CharSequence key = pathElement.asKey().toCharSequence();
                        node = objectNode.getNode(key);
                        continue block6;
                    }
                    case ARRAY: {
                        ArrayNode arrayNode = (ArrayNode)node;
                        node = arrayNode.getNodeAt(pathElement.asIndex().intValue());
                        continue block6;
                    }
                }
                if (node.isCollection()) {
                    node = node.asCollection().getNode(pathElement.asKey().toCharSequence());
                    continue;
                }
                throw new PathException("Looking up Path", "Path not found at " + path + " path element key " + pathElement.asKey().toString(), node.charSource(), node.rootElementToken().startIndex);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Path not found at " + path + " path element index " + pathElement.value());
        }
        return node;
    }

    public static PathNode toPath(String path) {
        PathParser pathParser = new PathParser();
        return pathParser.parse(path).getPathNode();
    }
}

