/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.BooleanNode;
import io.nats.jparse.node.CollectionNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.NullNode;
import io.nats.jparse.node.NumberNode;
import io.nats.jparse.node.ObjectNode;
import io.nats.jparse.node.StringNode;
import io.nats.jparse.node.support.NodeUtils;
import io.nats.jparse.node.support.TokenSubList;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ArrayNode
extends AbstractList<Node>
implements CollectionNode {
    private final TokenSubList tokens;
    private final CharSource source;
    private final Token rootToken;
    private final boolean objectsKeysCanBeEncoded;
    private int hashCode;
    private List<List<Token>> childrenTokens;
    private Node[] elements;
    private boolean hashCodeSet;

    public ArrayNode(TokenSubList tokens, CharSource source, boolean objectsKeysCanBeEncoded) {
        this.tokens = tokens;
        this.rootToken = tokens.get(0);
        this.source = source;
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
    }

    @Override
    public List<List<Token>> childrenTokens() {
        if (this.childrenTokens == null) {
            this.childrenTokens = NodeUtils.getChildrenTokens(this.tokens);
        }
        return this.childrenTokens;
    }

    Node[] elements() {
        if (this.elements == null) {
            this.elements = new Node[this.childrenTokens().size()];
        }
        return this.elements;
    }

    @Override
    public Node getNode(Object key) {
        return key instanceof String ? this.getNodeAt(Integer.valueOf((String)key)) : this.getNodeAt((Integer)key);
    }

    public Node getNodeAt(int index) {
        Node element = this.elements()[index];
        if (element == null) {
            List<Token> tokens = this.childrenTokens().get(index);
            this.elements()[index] = NodeUtils.createNode(tokens, this.source, this.objectsKeysCanBeEncoded);
        }
        return this.elements()[index];
    }

    public Optional<Node> lookupNodeAt(int index) {
        return Optional.ofNullable(this.getNodeAt(index));
    }

    public long getLong(int index) {
        return this.getNumberNode(index).longValue();
    }

    public double getDouble(int index) {
        return this.getNumberNode(index).doubleValue();
    }

    public double[] getDoubleArray() {
        int length = this.length();
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            Token token = this.tokens.get(i + 1);
            array[i] = this.source.getDouble(token.startIndex, token.endIndex);
        }
        return array;
    }

    public float[] getFloatArray() {
        int length = this.length();
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            Token token = this.tokens.get(i + 1);
            array[i] = this.source.getFloat(token.startIndex, token.endIndex);
        }
        return array;
    }

    public BigDecimal[] getBigDecimalArray() {
        int length = this.length();
        BigDecimal[] array = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            Token token = this.tokens.get(i + 1);
            array[i] = this.source.getBigDecimal(token.startIndex, token.endIndex);
        }
        return array;
    }

    public BigInteger[] getBigIntegerArray() {
        int length = this.length();
        BigInteger[] array = new BigInteger[length];
        for (int i = 0; i < length; ++i) {
            Token token = this.tokens.get(i + 1);
            array[i] = this.source.getBigDecimal(token.startIndex, token.endIndex).toBigInteger();
        }
        return array;
    }

    public int[] getIntArray() {
        int length = this.length();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            Token token = this.tokens.get(i + 1);
            array[i] = this.source.getInt(token.startIndex, token.endIndex);
        }
        return array;
    }

    public long[] getLongArray() {
        int length = this.length();
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            Token token = this.tokens.get(i + 1);
            array[i] = this.source.getLong(token.startIndex, token.endIndex);
        }
        return array;
    }

    public int getInt(int index) {
        return this.getNumberNode(index).intValue();
    }

    public NullNode getNullNode(int index) {
        return (NullNode)this.getNodeAt(index);
    }

    public float getFloat(int index) {
        return this.getNumberNode(index).floatValue();
    }

    public NumberNode getNumberNode(int index) {
        return (NumberNode)this.getNodeAt(index);
    }

    public BigDecimal getBigDecimal(int index) {
        return this.getNumberNode(index).bigDecimalValue();
    }

    public BigInteger getBigInteger(int index) {
        return this.getNumberNode(index).bigIntegerValue();
    }

    public StringNode getStringNode(int index) {
        return (StringNode)this.getNodeAt(index);
    }

    public String getString(int index) {
        return this.getStringNode(index).toString();
    }

    public ObjectNode getObjectNode(int index) {
        return (ObjectNode)this.getNodeAt(index);
    }

    public ArrayNode getArray(int index) {
        return (ArrayNode)this.getNodeAt(index);
    }

    public BooleanNode getBooleanNode(int index) {
        return (BooleanNode)this.getNodeAt(index);
    }

    public boolean getBoolean(int index) {
        return this.getBooleanNode(index).booleanValue();
    }

    @Override
    public int length() {
        return this.elements().length;
    }

    @Override
    public NodeType type() {
        return NodeType.ARRAY;
    }

    @Override
    public List<Token> tokens() {
        return this.tokens;
    }

    @Override
    public Token rootElementToken() {
        return this.rootToken;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    @Override
    public Node get(int index) {
        Node node = this.getNodeAt(index);
        return node.type() == NodeType.NULL ? null : node;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        if (this.tokens.size() != other.tokens.size()) {
            return false;
        }
        for (int index = 0; index < this.tokens.size(); ++index) {
            String otherStr;
            String thisStr;
            Token thisValue = this.tokens.get(index);
            Token otherValue = other.tokens.get(index);
            if (otherValue == null && thisValue == null || (thisStr = thisValue.asString(this.source)).equals(otherStr = otherValue.asString(other.source))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = Objects.hash(this.tokens.stream().map((? super T tok) -> tok.asString(this.source)).collect(Collectors.toList()));
        this.hashCodeSet = true;
        return this.hashCode;
    }

    @Override
    public int size() {
        return this.childrenTokens().size();
    }

    @Override
    public String toString() {
        return this.originalString();
    }

    public <R> List<R> mapObjectNode(Function<ObjectNode, ? extends R> mapper) {
        return this.map(node -> mapper.apply(node.asCollection().asObject()));
    }

    public <R> List<R> map(Function<Node, ? extends R> mapper) {
        ArrayList<R> list = new ArrayList<R>(this.size());
        Node[] elements = this.elements();
        for (int i = 0; i < elements.length; ++i) {
            Node element = elements[i];
            if (element == null) {
                elements[i] = element = this.getNodeAt(i);
            }
            list.add(mapper.apply(element));
        }
        return list;
    }

    public Optional<ObjectNode> findObjectNode(Predicate<ObjectNode> predicate) {
        Node[] elements = this.elements();
        ObjectNode node = null;
        for (int i = 0; i < elements.length; ++i) {
            ObjectNode objectNode;
            Node element = elements[i];
            if (element == null) {
                element = this.getNodeAt(i);
            }
            if (element.type() != NodeType.OBJECT || !predicate.test(objectNode = element.asCollection().asObject())) continue;
            node = objectNode;
            break;
        }
        return Optional.ofNullable(node);
    }

    public Optional<Node> find(Predicate<Node> predicate) {
        Node[] elements = this.elements();
        Node node = null;
        for (int i = 0; i < elements.length; ++i) {
            Node element = elements[i];
            if (element == null) {
                element = this.getNodeAt(i);
            }
            if (!predicate.test(element)) continue;
            node = element;
            break;
        }
        return Optional.ofNullable(node);
    }

    public List<ObjectNode> filterObjects(Predicate<ObjectNode> predicate) {
        Node[] elements = this.elements();
        int length = elements.length;
        ArrayList<ObjectNode> arrayList = new ArrayList<ObjectNode>(length / 2);
        for (int i = 0; i < length; ++i) {
            ObjectNode objectNode;
            Node element = elements[i];
            if (element == null) {
                element = this.getNodeAt(i);
            }
            if (element.type() != NodeType.OBJECT || !predicate.test(objectNode = element.asCollection().asObject())) continue;
            arrayList.add(objectNode);
        }
        return arrayList;
    }

    public List<Node> filter(Predicate<Node> predicate) {
        Node[] elements = this.elements();
        int length = elements.length;
        ArrayList<Node> arrayList = new ArrayList<Node>(length / 2);
        for (int i = 0; i < length; ++i) {
            Node element = elements[i];
            if (element == null) {
                element = this.getNodeAt(i);
            }
            if (!predicate.test(element)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }
}

