/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.Collections;
import java.util.List;

public class BooleanNode
implements ScalarNode {
    private final Token token;
    private final CharSource source;
    private final boolean value;

    public BooleanNode(Token token, CharSource source) {
        this.token = token;
        this.source = source;
        this.value = source.getChartAt(token.startIndex) == 't';
    }

    @Override
    public NodeType type() {
        return NodeType.BOOLEAN;
    }

    @Override
    public List<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    @Override
    public Token rootElementToken() {
        return this.token;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value ? 4 : 5;
    }

    @Override
    public Object value() {
        return this.booleanValue();
    }

    @Override
    public char charAt(int index) {
        if (this.value) {
            switch (index) {
                case 0: {
                    return 't';
                }
                case 1: {
                    return 'r';
                }
                case 2: {
                    return 'u';
                }
                case 3: {
                    return 'e';
                }
            }
            throw new IllegalStateException();
        }
        switch (index) {
            case 0: {
                return 'f';
            }
            case 1: {
                return 'a';
            }
            case 2: {
                return 'l';
            }
            case 3: {
                return 's';
            }
            case 4: {
                return 'e';
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String toString() {
        return this.value ? "true" : "false";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BooleanNode) {
            BooleanNode that = (BooleanNode)o;
            return this.value == that.value;
        }
        if (o instanceof Boolean) {
            Boolean that = (Boolean)o;
            return this.value == that;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

