/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.Path;
import io.nats.jparse.node.CollectionNode;
import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.List;

public interface Node
extends CharSequence {
    public NodeType type();

    public List<Token> tokens();

    public Token rootElementToken();

    public CharSource charSource();

    public boolean isScalar();

    public boolean isCollection();

    default public ScalarNode asScalar() {
        return (ScalarNode)this;
    }

    default public CollectionNode asCollection() {
        return (CollectionNode)this;
    }

    @Override
    default public int length() {
        Token token = this.rootElementToken();
        return token.endIndex - token.startIndex;
    }

    @Override
    default public char charAt(int index) {
        return this.charSource().getChartAt(this.rootElementToken().startIndex + index);
    }

    @Override
    default public CharSequence subSequence(int start, int end) {
        Token token = this.rootElementToken();
        return this.charSource().getCharSequence(start + token.startIndex, end + token.startIndex);
    }

    default public String originalString() {
        return this.charSource().getString(this.rootElementToken().startIndex, this.rootElementToken().endIndex);
    }

    default public String toJsonString() {
        return this.originalString();
    }

    default public CharSequence originalCharSequence() {
        return this.charSource().getCharSequence(this.rootElementToken().startIndex, this.rootElementToken().endIndex);
    }

    default public CharSequence toJsonCharSequence() {
        return this.originalCharSequence();
    }

    default public boolean equalsContent(String content) {
        return this.equals(content);
    }

    default public Node atPath(String path) {
        return Path.atPath(path, this);
    }
}

