/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.token.TokenTypes;

public enum NodeType implements TokenTypes
{
    ROOT(-1),
    OBJECT(0),
    ARRAY(3),
    INT(5),
    FLOAT(6),
    STRING(7),
    BOOLEAN(8),
    NULL(9),
    PATH_KEY(10),
    PATH_INDEX(11),
    PATH(-1),
    OTHER(-2);

    private final int tokenType;

    private NodeType(int tokenType) {
        this.tokenType = tokenType;
    }

    public static NodeType tokenTypeToElement(int tokenType) {
        switch (tokenType) {
            case 0: {
                return OBJECT;
            }
            case 3: {
                return ARRAY;
            }
            case 5: {
                return INT;
            }
            case 6: {
                return FLOAT;
            }
            case 7: {
                return STRING;
            }
            case 8: {
                return BOOLEAN;
            }
            case 9: {
                return NULL;
            }
            case 10: {
                return PATH_KEY;
            }
            case 11: {
                return PATH_INDEX;
            }
        }
        throw new IllegalStateException(String.valueOf(tokenType));
    }
}

